/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.authentication;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ApplicationDefaultCredentialsAuth
extends AbstractAuthentication {
    private final Set<String> m_scopes = new HashSet<String>();

    public ApplicationDefaultCredentialsAuth(BQConnectionOptions.ProxySettings proxySettings, BQConnectionOptions.TrustStoreSettings trustStoreSettings) throws ErrorException {
        super(BQConnectionOptions.OAuthMechanism.APPLICATION_DEFAULT_CREDENTIALS, trustStoreSettings, proxySettings);
        this.m_scopes.add("https://www.googleapis.com/auth/bigquery");
    }

    public void addScope(String string) {
        this.m_scopes.add(string);
    }

    @Override
    public GoogleCredentials buildCredentials() throws ErrorException {
        try {
            return GoogleCredentials.getApplicationDefault((HttpTransportFactory)this.m_transportFactory).createScoped(this.m_scopes);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_APPLICATION_DEFAULT_ERR.name(), (Throwable)iOException);
        }
    }
}

