/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.security.GeneralSecurityException;

public class BQHttpTransportFactory
implements HttpTransportFactory {
    NetHttpTransport.Builder m_transportBuilder;

    public BQHttpTransportFactory(BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        this.m_transportBuilder = this.initializeHttpTransport(trustStoreSettings, proxySettings);
    }

    private NetHttpTransport.Builder initializeHttpTransport(BQConnectionOptions.TrustStoreSettings trustStoreSettings, final BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        try {
            Proxy proxy = null;
            if (null != proxySettings) {
                if (null != proxySettings.m_uid) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            PasswordAuthentication passwordAuthentication = null;
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxySettings.m_host) && this.getRequestingPort() == proxySettings.m_port) {
                                passwordAuthentication = new PasswordAuthentication(proxySettings.m_uid, proxySettings.m_pwd.toCharArray());
                            }
                            return passwordAuthentication;
                        }
                    });
                }
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.m_host, proxySettings.m_port));
            }
            NetHttpTransport.Builder builder = new NetHttpTransport.Builder().setProxy(proxy);
            if (null != trustStoreSettings) {
                FileInputStream fileInputStream;
                try {
                    fileInputStream = new FileInputStream(trustStoreSettings.m_trustStore);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                }
                builder.trustCertificatesFromJavaKeyStore((InputStream)fileInputStream, trustStoreSettings.m_trustStorePwd);
            } else {
                builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
            }
            return builder;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_SECURITY_ERR.name(), generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
    }

    public HttpTransport create() {
        return this.m_transportBuilder.build();
    }
}

