/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.ProjectReference;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.storage.v1.AvroSerializationOptions;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.simba.googlebigquery.googlebigquery.BQExecutionContext;
import com.simba.googlebigquery.googlebigquery.client.BQHttpTransportFactory;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.client.queryclient.QueryClient;
import com.simba.googlebigquery.googlebigquery.client.queryclient.QueryContext;
import com.simba.googlebigquery.googlebigquery.client.requests.FetchQueryResultsRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.datasets.DatasetsListRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsCancelRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsGetRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.projects.ProjectsListRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.routines.RoutinesGetRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.routines.RoutinesListRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.tables.TablesGetRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.tables.TablesListRequest;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class BQClient {
    private static final int MAX_HTAPI_STREAMS = 1;
    private Bigquery m_bqClient;
    private final QueryClient.Builder m_queryClientBuilder;
    private GoogleCredentials m_bqStorageCredential;
    private final BQConnectionOptions m_connectionOptions;
    private final ILogger m_connLogger;
    private BigQueryReadClient m_readClient;
    private ReadSession m_readSession = null;
    private String m_tableReference = null;
    private final String m_userAgent;

    public BQClient(ILogger iLogger, BQConnectionOptions bQConnectionOptions) {
        this.m_connLogger = iLogger;
        this.m_connectionOptions = bQConnectionOptions;
        this.m_queryClientBuilder = new QueryClient.Builder();
        this.m_userAgent = "SimbaJDBCDriverforGoogleBigQuery/1.3 (GPN:Simba;)";
    }

    public void cancelQuery(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        new JobsCancelRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setJobId(string2).setLocation(string3).executeWithRetry();
    }

    public IBQResponse executeQuery(BQExecutionContext bQExecutionContext, Object object, AtomicBoolean atomicBoolean) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[]{bQExecutionContext.query, bQExecutionContext.projectId, bQExecutionContext.defaultDataset, bQExecutionContext.useDestinationTable, bQExecutionContext.queryDialect, null != bQExecutionContext.KMSKeyName ? "with CMEK" : "default key", atomicBoolean});
        return this.m_queryClientBuilder.setLogger(this.m_connLogger).setBigQueryClient(this.m_bqClient).setExecutionContext(bQExecutionContext).setConnectionOptions(this.m_connectionOptions).setQueryContext(new QueryContext(atomicBoolean, object, this.m_connectionOptions)).build().executeQuery();
    }

    public List<TableFieldSchema> getColumns(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        TableSchema tableSchema = ((Table)new TablesGetRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setDatasetId(string2).setTableId(string3).executeWithRetry()).getSchema();
        return null == tableSchema ? null : tableSchema.getFields();
    }

    public List<DatasetList> getDatasetLists(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string);
        ArrayList<DatasetList> arrayList = new ArrayList<DatasetList>();
        String string2 = null;
        do {
            DatasetList datasetList = (DatasetList)new DatasetsListRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setMaxResults(this.m_connectionOptions.m_maxResults).setPageToken(string2).executeWithRetry();
            string2 = datasetList.getNextPageToken();
            arrayList.add(datasetList);
        } while (null != string2 && !string2.isEmpty());
        return arrayList;
    }

    public ArrayList<String> getProjects() throws ErrorException {
        String[] stringArray;
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        do {
            if (null != (stringArray = (String[])new ProjectsListRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setPageToken(string).setMaxResults(this.m_connectionOptions.m_maxResults).executeWithRetry())) {
                string = stringArray.getNextPageToken();
                if (stringArray.isEmpty()) continue;
                arrayList.addAll(stringArray.getProjects().stream().map(ProjectList.Projects::getProjectReference).map(ProjectReference::getProjectId).collect(Collectors.toList()));
                continue;
            }
            string = null;
        } while (null != string && !string.isEmpty());
        if (null != this.m_connectionOptions.m_additionalProjects && 0 != (stringArray = this.m_connectionOptions.m_additionalProjects.trim().split(",")).length) {
            for (String string2 : stringArray) {
                if (string2.isEmpty()) continue;
                try {
                    DatasetList datasetList = (DatasetList)new DatasetsListRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string2).setMaxResults(1L).executeWithRetry();
                    if (null == datasetList || arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
                catch (Exception exception) {
                    LogUtilities.logWarning(exception.getMessage(), this.m_connLogger);
                }
            }
        }
        return arrayList;
    }

    public GetQueryResultsResponse getQueryResults(String string, String string2, String string3, String string4, long l, long l2, BQBufferManager bQBufferManager) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string4, l, l2, bQBufferManager);
        return (GetQueryResultsResponse)new FetchQueryResultsRequest(this.m_connLogger, l, this.m_bqClient).setBufferManager(bQBufferManager).setProjectId(string2).setJobId(string).setLocation(string3).setPageToken(string4).setMaxResults(l2).executeWithRetry();
    }

    public Table getTable(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        return (Table)new TablesGetRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setDatasetId(string2).setTableId(string3).executeWithRetry();
    }

    public List<TableList> getTableList(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string);
        ArrayList<TableList> arrayList = new ArrayList<TableList>();
        for (DatasetList datasetList : this.getDatasetLists(string)) {
            List list = datasetList.getDatasets();
            for (DatasetList.Datasets datasets : list) {
                DatasetReference datasetReference = datasets.getDatasetReference();
                if (datasetReference == null) continue;
                arrayList.addAll(this.getTableList(string, datasetReference.getDatasetId()));
            }
        }
        return arrayList;
    }

    public List<TableList> getTableList(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        ArrayList<TableList> arrayList = new ArrayList<TableList>();
        String string3 = "";
        do {
            TableList tableList;
            if (null == (tableList = (TableList)new TablesListRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setDatasetId(string2).setPageToken(string3).executeWithRetry())) continue;
            string3 = tableList.getNextPageToken();
            if (tableList.isEmpty()) continue;
            arrayList.add(tableList);
        } while (null != string3 && !string3.isEmpty());
        return arrayList;
    }

    public Routine getFunction(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        return (Routine)new RoutinesGetRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setDatasetId(string2).setRoutineId(string3).executeWithRetry();
    }

    public List<ListRoutinesResponse> getFunctionList(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        ArrayList<ListRoutinesResponse> arrayList = new ArrayList<ListRoutinesResponse>();
        String string4 = "";
        do {
            ListRoutinesResponse listRoutinesResponse;
            if (null != (listRoutinesResponse = (ListRoutinesResponse)new RoutinesListRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setDatasetId(string2).setMaxResults(this.m_connectionOptions.m_maxResults).setTypeFilter(string3).setPageToken(string4).executeWithRetry())) {
                string4 = listRoutinesResponse.getNextPageToken();
                arrayList.add(listRoutinesResponse);
                continue;
            }
            string4 = "";
        } while (null != string4 && !string4.isEmpty());
        return arrayList;
    }

    public Job prepare(BQExecutionContext bQExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        return this.m_queryClientBuilder.setLogger(this.m_connLogger).setBigQueryClient(this.m_bqClient).setConnectionOptions(this.m_connectionOptions).setExecutionContext(bQExecutionContext).build().executeDryRun();
    }

    public void authenticateAndTest(AbstractAuthentication abstractAuthentication, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        GoogleCredentials googleCredentials = abstractAuthentication.buildCredentials();
        HttpCredentialsAdapter httpCredentialsAdapter = new HttpCredentialsAdapter((Credentials)googleCredentials);
        GsonFactory gsonFactory = GsonFactory.getDefaultInstance();
        HttpTransport httpTransport = new BQHttpTransportFactory(trustStoreSettings, proxySettings).create();
        this.createAndTestClient((HttpRequestInitializer)httpCredentialsAdapter, (JsonFactory)gsonFactory, httpTransport);
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            this.m_bqStorageCredential = googleCredentials;
            this.createBigQueryStorageClient();
        }
    }

    public void createBigQueryStorageClient() throws ErrorException {
        try {
            CredentialsProvider credentialsProvider = () -> this.m_bqStorageCredential;
            HeaderProvider headerProvider = () -> {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("user-agent", this.m_userAgent);
                return hashMap;
            };
            BigQueryReadSettings.Builder builder = BigQueryReadSettings.newBuilder();
            builder.setCredentialsProvider(credentialsProvider);
            if (!this.m_connectionOptions.m_baseUrls.getReadApiUri().isEmpty()) {
                builder.setEndpoint(this.m_connectionOptions.m_baseUrls.getReadApiUri());
            }
            builder.setHeaderProvider(headerProvider);
            this.m_readClient = BigQueryReadClient.create((BigQueryReadSettings)builder.build());
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_BIGQUERYSTORAGECLIENT_OBJ_ERR.name(), this.m_connectionOptions.m_OAuthType.toString(), (Throwable)exception);
        }
    }

    public ReadSession createReadSession(String string, String string2) throws ErrorException {
        if (null == this.m_tableReference) {
            try {
                this.m_tableReference = this.getTableReference(string, string2);
            }
            catch (GoogleJsonResponseException | ErrorException throwable) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_HTAPI_COPY_DATA_TO_TEMP_ERR.name(), throwable);
            }
        }
        AvroSerializationOptions avroSerializationOptions = AvroSerializationOptions.newBuilder().setEnableDisplayNameAttribute(true).build();
        ReadSession.TableReadOptions tableReadOptions = ReadSession.TableReadOptions.newBuilder().setAvroSerializationOptions(avroSerializationOptions).build();
        ReadSession.Builder builder = ReadSession.newBuilder().setTable(this.m_tableReference).setDataFormat(DataFormat.AVRO).setReadOptions(tableReadOptions);
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setReadSession(builder).setParent("projects/" + this.m_connectionOptions.m_projectId).setMaxStreamCount(1).build();
        this.m_readSession = this.m_readClient.createReadSession(createReadSessionRequest);
        return this.m_readSession;
    }

    public BigQueryReadClient getBigQueryStorageClient() {
        return this.m_readClient;
    }

    public ReadSession getReadSession() {
        return this.m_readSession;
    }

    public void resetHTAPIVariables() {
        this.m_tableReference = null;
    }

    private String getTableReference(String string, String string2) throws ErrorException, GoogleJsonResponseException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        Job job = this.getJob(this.m_connectionOptions.m_projectId, string, string2);
        TableReference tableReference = job.getConfiguration().getQuery().getDestinationTable();
        return "projects/" + tableReference.getProjectId() + "/datasets/" + tableReference.getDatasetId() + "/tables/" + tableReference.getTableId();
    }

    private void createAndTestClient(final HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, HttpTransport httpTransport) throws ErrorException {
        HttpRequestInitializer httpRequestInitializer2 = new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                httpRequestInitializer.initialize(httpRequest);
                httpRequest.setConnectTimeout(120000);
                httpRequest.setReadTimeout(120000);
            }
        };
        Bigquery.Builder builder = new Bigquery.Builder(httpTransport, jsonFactory, httpRequestInitializer2);
        builder.setApplicationName(this.m_userAgent);
        if (!this.m_connectionOptions.m_baseUrls.getBigQueryUri().isEmpty()) {
            builder.setRootUrl(this.m_connectionOptions.m_baseUrls.getBigQueryUri());
        }
        this.m_bqClient = builder.build();
        try {
            BQExecutionContext bQExecutionContext = new BQExecutionContext(this.m_connectionOptions);
            bQExecutionContext.query = "select 1";
            this.prepare(bQExecutionContext);
        }
        catch (ErrorException errorException) {
            if (errorException.hasMessageParams()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), errorException.getMessageParams(), (Throwable)errorException);
            }
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), errorException.getMessage());
        }
    }

    public Job getJob(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        return (Job)new JobsGetRequest(this.m_connLogger, this.m_connectionOptions.m_timeout, this.m_bqClient).setProjectId(string).setJobId(string2).setLocation(string3).executeWithRetry();
    }

    public void beginTransaction(BQConnectionOptions bQConnectionOptions) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        BQExecutionContext bQExecutionContext = new BQExecutionContext(bQConnectionOptions);
        bQExecutionContext.useDestinationTable = false;
        bQExecutionContext.useJobsQuery = false;
        bQExecutionContext.query = "begin transaction;";
        Object object = new Object();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.executeQuery(bQExecutionContext, object, atomicBoolean);
    }

    public void commitTransaction(BQConnectionOptions bQConnectionOptions) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        BQExecutionContext bQExecutionContext = new BQExecutionContext(bQConnectionOptions);
        bQExecutionContext.useDestinationTable = false;
        bQExecutionContext.useJobsQuery = false;
        bQExecutionContext.query = "commit transaction;";
        Object object = new Object();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.executeQuery(bQExecutionContext, object, atomicBoolean);
    }

    public void rollbackTransaction(BQConnectionOptions bQConnectionOptions) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        BQExecutionContext bQExecutionContext = new BQExecutionContext(bQConnectionOptions);
        bQExecutionContext.useDestinationTable = false;
        bQExecutionContext.useJobsQuery = false;
        bQExecutionContext.query = "rollback transaction;";
        Object object = new Object();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.executeQuery(bQExecutionContext, object, atomicBoolean);
    }
}

