/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.dataengine.impl;

import com.simba.googlebigquery.dsi.core.impl.DSIDriver;
import com.simba.googlebigquery.dsi.dataengine.impl.DSISimpleResultSet;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IColumn;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.utilities.DSIMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Iterator;

class DSIArrayResultSet
extends DSISimpleResultSet {
    private static final String INDEX_COLUMN_NAME = "INDEX";
    private static final String VALUE_COLUMN_NAME = "VALUE";
    private final long m_startIndex;
    private final long m_maxSize;
    private long m_currentRow = -1L;
    private Iterator<?> m_iterator;
    private Object m_data;
    private ArrayList<? extends IColumn> m_selectColumns;
    private TypeMetadata m_typeMetadata;

    DSIArrayResultSet(Iterator<?> iterator, IColumn iColumn, long l, int n) {
        if (null == iterator) {
            throw new NullPointerException("iterator");
        }
        if (0L > l) {
            throw new IndexOutOfBoundsException("offset: " + l);
        }
        if (0 > n && -1 != n) {
            throw new IllegalArgumentException("count: " + n);
        }
        this.m_iterator = iterator;
        this.m_startIndex = l + 1L;
        this.m_maxSize = n;
        this.m_selectColumns = DSIArrayResultSet.initializeSelectColumns(iColumn);
        this.m_typeMetadata = iColumn.getTypeMetadata();
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        if (0L > this.m_currentRow) {
            throw new IllegalStateException();
        }
        switch (n) {
            case 0: {
                dataWrapper.setBigInt(this.m_startIndex + this.m_currentRow);
                return false;
            }
            case 1: {
                short s = this.m_typeMetadata.getType();
                if (null == this.m_data) {
                    dataWrapper.setNull(s);
                    return false;
                }
                try {
                    if (TypeUtilities.isCharacterType(s)) {
                        String string = (String)this.m_data;
                        long l3 = l / 2L;
                        long l4 = -1L != l2 ? l2 / 2L : l2;
                        return DSITypeUtilities.outputString(string, dataWrapper, l3, l4, s);
                    }
                    if (TypeUtilities.isBinaryType(s)) {
                        byte[] byArray = (byte[])this.m_data;
                        return DSITypeUtilities.outputBytes(byArray, dataWrapper, l, l2, s);
                    }
                    dataWrapper.setData(s, this.m_data);
                    return false;
                }
                catch (ClassCastException classCastException) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(s), this.m_data.getClass().getName()});
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(s), this.m_data.getClass().getName()});
                }
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(n + 1), ExceptionType.DATA);
    }

    @Override
    public long getRowCount() throws ErrorException {
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_selectColumns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        if (null == this.m_iterator) {
            return false;
        }
        if (-1L != this.m_maxSize && this.m_maxSize <= this.m_currentRow) {
            return false;
        }
        return this.m_iterator.hasNext();
    }

    @Override
    public boolean hasRowCount() {
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.m_iterator = null;
        this.m_currentRow = -1L;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        if (this.hasMoreRows()) {
            ++this.m_currentRow;
            this.m_data = this.m_iterator.next();
            return true;
        }
        return false;
    }

    private static ArrayList<ColumnMetadata> initializeSelectColumns(IColumn iColumn) {
        ColumnMetadata columnMetadata;
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(2);
        try {
            columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, false));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
        columnMetadata.setName(INDEX_COLUMN_NAME);
        columnMetadata.setLabel(INDEX_COLUMN_NAME);
        arrayList.add(columnMetadata);
        ColumnMetadata columnMetadata2 = ColumnMetadata.copyOf(iColumn);
        columnMetadata2.setName(VALUE_COLUMN_NAME);
        columnMetadata2.setLabel(VALUE_COLUMN_NAME);
        arrayList.add(columnMetadata2);
        return arrayList;
    }
}

