/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public abstract class UnsignedBigIntJDBCDataSink
extends NumberJDBCDataSink<BigInteger> {
    private static final BigDecimal LONG_MAX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigInteger TWO_TO_64 = BigInteger.valueOf(2L).pow(64);

    public UnsignedBigIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    protected abstract void doSet(BigInteger var1) throws ErrorException;

    @Override
    protected abstract void doSet(Long var1) throws ErrorException;

    private void setFromLong(long l, String string) throws ErrorException, ConversionFailed {
        if (l >= 0L) {
            this.doSet(l);
        } else {
            this.setBigInteger(BigInteger.valueOf(l), string);
        }
    }

    protected void setBigInteger(BigInteger bigInteger, String string) throws ErrorException, ConversionFailed {
        if (bigInteger == null) {
            this.doSet((BigInteger)null);
        } else {
            BigInteger bigInteger2 = bigInteger.mod(TWO_TO_64);
            if (!bigInteger2.equals(bigInteger)) {
                this.onOverflow(bigInteger, string);
            }
            this.doSet(bigInteger2);
        }
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException, ConversionFailed {
        if (object == null) {
            this.doSet((Long)null);
        } else if (object instanceof Long) {
            this.setFromLong((Long)object, "set");
        } else if (object instanceof BigInteger) {
            this.setBigInteger((BigInteger)object, "set");
        } else {
            BigDecimal bigDecimal = NonTrivialJDBCConversions.objectToBigDecimal(object, null, this.getAndClearListener());
            BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(bigInteger);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setFromLong(l, "setLong");
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigInteger bigInteger = NonTrivialJDBCConversions.DoubleConverter.toUInt64(f, this.getAndClearListener());
        this.handleConversionResult(Float.valueOf(f), "setFloat");
        this.doSet(bigInteger);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigInteger bigInteger = NonTrivialJDBCConversions.DoubleConverter.toUInt64(d, this.getAndClearListener());
        this.handleConversionResult(d, "setDouble");
        this.doSet(bigInteger);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else if (bigDecimal.compareTo(LONG_MIN) >= 0 && bigDecimal.compareTo(LONG_MAX) <= 0) {
            this.setLong(bigDecimal.longValue());
        } else {
            BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.doSet(bigInteger);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setFromLong(Long.parseLong(string), "setString");
            }
            catch (NumberFormatException numberFormatException) {
                BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.doSet(bigInteger);
            }
        }
    }
}

