/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class DoubleJDBCDataSink
extends NumberJDBCDataSink<Double> {
    public DoubleJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        block4: {
            try {
                if (object == null || object instanceof Double) {
                    this.doSet(null);
                    break block4;
                }
                if (object instanceof Number) {
                    this.doSet(((Number)object).doubleValue());
                    break block4;
                }
                throw new IncorrectTypeException();
            }
            catch (ConversionFailed conversionFailed) {
                throw new RuntimeException("Should never happen!", conversionFailed);
            }
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setDouble(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setDouble(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setDouble(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setDouble(l);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setDouble(f);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(d);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setDouble(bigDecimal.doubleValue());
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            try {
                this.setDouble(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionFailed(numberFormatException);
            }
        }
    }
}

