/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DateJDBCDataSink
extends ConvertingJDBCDataSink {
    public DateJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected abstract void doSet(Date var1, Calendar var2) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof Date)) {
            throw new IncorrectTypeException();
        }
        this.doSet((Date)object, this.getLocalCalendarForConversions());
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 91: 
            case 93: 
            case 2000: {
                this.doSet(null, null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            this.setDate(NonTrivialJDBCConversions.stringToDate(string, this.getLocalCalendarForConversions()), this.getLocalCalendarForConversions());
        }
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        this.doSet(date, calendar);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        this.doSet(NonTrivialJDBCConversions.timestampToDate(timestamp, calendar), calendar);
    }
}

