/*
 * Decompiled with CFR 0.152.
 */
package bpm.profiling.runtime.core;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import bpm.metadata.layer.logical.ICalculatedElement;
import bpm.metadata.layer.logical.IDataStream;
import bpm.metadata.layer.logical.IDataStreamElement;
import bpm.metadata.layer.logical.sql.SQLDataSource;
import bpm.metadata.layer.physical.sql.SQLColumn;
import bpm.profiling.runtime.core.Column;
import bpm.profiling.runtime.core.Table;
import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.DriverShim;
import bpm.studio.jdbc.management.model.ListDriver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Connection {
    public static Logger logger = Logger.getLogger((String)"bpm.profiling.runtime");
    private int id;
    private String name;
    private String host;
    private String port;
    private String driverName;
    private String login;
    private String password;
    private String databaseName;
    private String schemaName;
    private String fmdtConnectionName;
    private boolean isFromRepository = false;
    private Integer directoryItemId;
    private String fmdtDataSourceName;
    private Integer vanillaGroupId;
    private String fullUrl;
    private List<Table> tables = new ArrayList<Table>();

    public Integer getVanillaGroupId() {
        return this.vanillaGroupId;
    }

    public void setVanillaGroupId(Integer vanillaGroupId) {
        this.vanillaGroupId = vanillaGroupId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public VanillaJdbcConnection getJdbcConnection() throws Exception {
        String urlPrefix = "";
        urlPrefix = this.init();
        VanillaJdbcConnection con = null;
        String url = String.valueOf(urlPrefix) + this.host + ":" + this.port + "/" + this.databaseName;
        try {
            con = ConnectionManager.getInstance().getJdbcConnection(url, this.login, this.password, ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getInfo(this.driverName).getClassName());
            return con;
        }
        catch (Exception e) {
            logger.error((Object)("Error while connecting to " + url), (Throwable)e);
            throw e;
        }
    }

    private String init() throws Exception {
        DriverInfo info = ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getInfo(this.driverName);
        String urlPrefix = info.getUrlPrefix();
        return urlPrefix;
    }

    private static void registerDriver(String path, String driverClassName) throws Exception {
        try {
            File f = null;
            f = IConstants.getJdbcJarFolder().endsWith("/") || path.startsWith("/") ? new File(String.valueOf(IConstants.getJdbcJarFolder()) + path) : new File(String.valueOf(IConstants.getJdbcJarFolder()) + "/" + path);
            if (!f.exists()) {
                throw new Exception("Unable to find JDBC Jar File " + f.getAbsolutePath());
            }
            URL u = f.toURL();
            logger.info((Object)("Try to load class " + driverClassName + " from " + f.toURL()));
            URLClassLoader ucl = new URLClassLoader(new URL[]{u});
            Driver d = (Driver)Class.forName(driverClassName, true, ucl).newInstance();
            DriverManager.registerDriver((Driver)new DriverShim(d));
            logger.info((Object)("JDBC driver " + driverClassName + " loaded"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            logger.error((Object)("Error(url) while loading JDBC driver " + driverClassName + " from path"));
            throw e;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("Error(instant) while loading JDBC driver " + driverClassName + " from path"));
            throw e;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("Error(illegal) while loading JDBC driver " + driverClassName + " from path"));
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("Error(sql) while loading JDBC driver " + driverClassName + " from path"));
            throw e;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<Table> connect() throws Exception {
        DatabaseMetaData dmd;
        this.tables.clear();
        String urlPrefix = "";
        urlPrefix = this.init();
        VanillaJdbcConnection con = null;
        ResultSet rs = null;
        ResultSet colRs = null;
        VanillaPreparedStatement stmt = null;
        this.fullUrl = String.valueOf(urlPrefix) + this.host + ":" + this.port + "/" + this.databaseName;
        try {
            logger.info((Object)("Connecting to " + this.fullUrl + " ..."));
            con = ConnectionManager.getInstance().getJdbcConnection(this.fullUrl, this.login, this.password, ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getInfo(this.driverName).getClassName());
            logger.info((Object)("Connected to " + this.fullUrl + " ..."));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Exception("SQL Connection failed for " + this.fullUrl + "<" + this.login + "><" + this.password + ">\n" + "SQLCode:" + e.getErrorCode());
        }
        try {
            dmd = con.getMetaData();
            logger.info((Object)("Driver Version : " + dmd.getDriverVersion()));
            logger.info((Object)("Driver Name : " + dmd.getDriverName()));
            logger.info((Object)("DataBase Product Version :" + dmd.getDatabaseProductVersion()));
            stmt = con.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Exception("Unable to create SQL statement\nSQLCode:" + e.getErrorCode());
        }
        try {
            logger.info((Object)("Browsing catalog : " + con.getCatalog() + " schema: " + this.schemaName));
            rs = dmd.getTables(con.getCatalog(), this.schemaName, "%", new String[]{"ALIAS"});
            this.addTable(this.tables, rs, stmt, colRs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Exception("Unable to get SQL Aliases\nSQLCode:" + e.getErrorCode());
        }
        try {
            rs = dmd.getTables(con.getCatalog(), this.schemaName, "%", new String[]{"VIEW"});
            this.addTable(this.tables, rs, stmt, colRs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Exception("Unable to get SQL Views\nSQLCode:" + e.getErrorCode());
        }
        try {
            rs = dmd.getTables(con.getCatalog(), this.schemaName, "%", new String[]{"TABLE"});
            this.addTable(this.tables, rs, stmt, colRs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.closeAll(stmt, colRs, rs, con);
            throw new Exception("Unable to get SQL Tables\nSQLCode:" + e.getErrorCode());
        }
        this.closeAll(stmt, colRs, rs, con);
        return this.tables;
    }

    protected void closeAll(VanillaPreparedStatement stmt, ResultSet colRs, ResultSet rs, VanillaJdbcConnection con) throws Exception {
        if (stmt != null) {
            stmt.close();
        }
        if (colRs != null) {
            colRs.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (con != null) {
            ConnectionManager.getInstance().returnJdbcConnection(con);
        }
    }

    private void addTable(List<Table> list, ResultSet rs, VanillaPreparedStatement stmt, ResultSet colRs) throws Exception {
        while (rs.next()) {
            Table table = new Table();
            table.setName(rs.getString("TABLE_NAME"));
            table.setLabel(rs.getString("TABLE_NAME"));
            logger.debug((Object)("table : " + table.getName()));
            colRs = stmt.executeQuery("select * from " + table.getName() + " where 1=0");
            ResultSetMetaData metadata = colRs.getMetaData();
            logger.debug((Object)("nb cols : " + metadata.getColumnCount()));
            int i = 0;
            while (i < metadata.getColumnCount()) {
                logger.debug((Object)("    " + i + ":col:" + metadata.getColumnName(i + 1)));
                int index = i + 1;
                String name = metadata.getColumnName(index);
                String sqltype = metadata.getColumnTypeName(index);
                int prec = metadata.getPrecision(index);
                if (sqltype.equalsIgnoreCase("varchar")) {
                    sqltype = prec <= 21845 ? String.valueOf(sqltype) + "(" + prec + ")" : "TEXT";
                }
                Column col = new Column();
                col.setName(name);
                col.setLabel(name);
                col.setType(sqltype);
                table.addColumn(col);
                ++i;
            }
            table.setConnection(this);
            list.add(table);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<Table> connect(SQLDataSource sqlCon) throws Exception {
        for (IDataStream s : sqlCon.getDataStreams()) {
            Table t = new Table();
            t.setName(s.getOriginName());
            t.setLabel(s.getName());
            t.setConnection(this);
            for (IDataStreamElement e : s.getElements()) {
                Column c = new Column();
                c.setName(e.getOriginName());
                c.setLabel(e.getName());
                if (e instanceof ICalculatedElement) {
                    c.setType(((ICalculatedElement)e).getJavaClassName());
                } else {
                    c.setType(((SQLColumn)e.getOrigin()).getSqlType());
                }
                t.addColumn(c);
            }
            this.tables.add(t);
        }
        return this.tables;
    }

    public boolean getIsFromRepository() {
        return this.isFromRepository;
    }

    public void setIsFromRepository(boolean isFromRepository) {
        this.isFromRepository = isFromRepository;
    }

    public Integer getDirectoryItemId() {
        return this.directoryItemId;
    }

    public void setDirectoryItemId(Integer directoryItemId) {
        this.directoryItemId = directoryItemId;
    }

    public String getFmdtDataSourceName() {
        return this.fmdtDataSourceName;
    }

    public void setFmdtDataSourceName(String fmdtDataSourceName) {
        this.fmdtDataSourceName = fmdtDataSourceName;
    }

    public void setFmdtConnectionName(String name) {
        this.fmdtConnectionName = name;
    }

    public String getFmdtConnectionName() {
        return this.fmdtConnectionName;
    }

    public String getFullUrl() {
        String urlPrefix = "";
        try {
            urlPrefix = this.init();
            this.fullUrl = String.valueOf(urlPrefix) + this.host + ":" + this.port + "/" + this.databaseName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fullUrl;
    }
}

