/*
 * Decompiled with CFR 0.152.
 */
package bpm.profiling.runtime.core;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import bpm.profiling.database.AnalysisManager;
import bpm.profiling.database.Helper;
import bpm.profiling.database.bean.AnalysisConditionResult;
import bpm.profiling.database.bean.AnalysisContentBean;
import bpm.profiling.database.bean.AnalysisInfoBean;
import bpm.profiling.database.bean.AnalysisResultBean;
import bpm.profiling.database.bean.RuleSetBean;
import bpm.profiling.runtime.core.Column;
import bpm.profiling.runtime.core.Condition;
import bpm.profiling.runtime.core.Connection;
import bpm.profiling.runtime.core.Table;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AnalysisExecutor {
    private static final String lowValueQuery = "select MIN($column) from $table";
    private static final String lowValueCountQuery = "select COUNT(*) from $table where $column=(select MIN($column) from $table)";
    private static final String hightValueQuery = "select MAX($column) from $table";
    private static final String hightValueCountQuery = "select COUNT(*) from $table where $column=(select MAX($column) from $table)";
    private static final String avgValueQuery = "select AVG($column) from $table";
    private static final String distinctCountQuery = "select  COUNT(DISTINCT $column) from $table ";
    private static final String zeroCountQuery = "select COUNT(*) from $table where $column=0";
    private static final String blankCountQuery = "select COUNT(*) from $table where $column=''";
    private static final String nullCountQuery = "select COUNT(*) from $table where $column IS NULL";
    private static final String countQuery = "select COUNT(*) from $table";
    private static final String[] queries = new String[]{"select MIN($column) from $table", "select COUNT(*) from $table where $column=(select MIN($column) from $table)", "select MAX($column) from $table", "select COUNT(*) from $table where $column=(select MAX($column) from $table)", "select AVG($column) from $table", "select  COUNT(DISTINCT $column) from $table ", "select COUNT(*) from $table where $column=0", "select COUNT(*) from $table where $column=''", "select COUNT(*) from $table where $column IS NULL", "select COUNT(*) from $table"};

    private static AnalysisResultBean executeAnalysis(Date currentDate, Connection connection, AnalysisContentBean contentBean) throws Exception {
        List<Table> tables = null;
        tables = connection.getTables().isEmpty() ? connection.connect() : connection.getTables();
        Table table = null;
        Column column = null;
        block17: for (Table t : tables) {
            if (!t.getLabel().equals(contentBean.getTableName())) continue;
            table = t;
            for (Column c : t.getColumns()) {
                if (!c.getLabel().equals(contentBean.getColumnName())) continue;
                column = c;
                break block17;
            }
        }
        List<String> preparedQueries = AnalysisExecutor.prepareQueries(table, column);
        boolean isString = false;
        if (column.getType().contains("CHAR") || column.getType().contains("char") || column.getType().contains("text") || column.getType().contains("TEXT") || column.getType().contains("DATE") || column.getType().contains("date") || column.getType().contains("time") || column.getType().contains("TIME") || column.getType().contains("STRING") || column.getType().contains("string")) {
            isString = true;
        }
        VanillaJdbcConnection sock = connection.getJdbcConnection();
        VanillaPreparedStatement stmt = sock.createStatement();
        AnalysisResultBean result = new AnalysisResultBean();
        try {
            result.setCreation(currentDate);
            result.setAnalysisContentId(contentBean.getId());
            result.setDataType(column.getType());
            int totalCount = 0;
            int i = 0;
            while (i < preparedQueries.size()) {
                try {
                    if (i != 4 || !isString) {
                        System.out.print(String.valueOf(preparedQueries.get(i)) + " = ");
                        ResultSet rs = stmt.executeQuery(preparedQueries.get(i));
                        rs.next();
                        System.out.println(rs.getObject(1));
                        switch (i) {
                            case 0: {
                                if (rs.getObject(1) == null) {
                                    result.setLowValue(null);
                                    break;
                                }
                                result.setLowValue(rs.getObject(1).toString());
                                break;
                            }
                            case 1: {
                                if (rs.getObject(1) == null) {
                                    result.setLowValueCount(null);
                                    break;
                                }
                                result.setLowValueCount(rs.getInt(1));
                                break;
                            }
                            case 2: {
                                if (rs.getObject(1) == null) {
                                    result.setHightValue(null);
                                    break;
                                }
                                result.setHightValue(rs.getObject(1).toString());
                                break;
                            }
                            case 3: {
                                if (rs.getObject(1) == null) {
                                    result.setHightValueCount(null);
                                    break;
                                }
                                result.setHightValueCount(rs.getInt(1));
                                break;
                            }
                            case 4: {
                                if (!isString) {
                                    result.setAvgValue(rs.getDouble(1));
                                    break;
                                }
                            }
                            case 5: {
                                result.setDistinctCount(rs.getInt(1));
                                break;
                            }
                            case 6: {
                                if (!isString) {
                                    result.setZeroCount(rs.getInt(1));
                                    break;
                                }
                            }
                            case 7: {
                                if (isString) {
                                    result.setBlankCount(rs.getInt(1));
                                    break;
                                }
                            }
                            case 8: {
                                result.setNullCount(rs.getInt(1));
                                break;
                            }
                            case 9: {
                                totalCount = rs.getInt(1);
                                if (isString) {
                                    if (result.getBlankCount() != null && totalCount != 0) {
                                        result.setBlankPercent((double)result.getBlankCount().intValue() / (double)totalCount);
                                    }
                                } else if (result.getZeroCount() != null && totalCount != 0) {
                                    result.setZeroPercent((double)result.getZeroCount().intValue() / (double)totalCount);
                                }
                                if (result.getNullCount() == null || totalCount == 0) break;
                                result.setNullPercent((double)result.getNullCount().intValue() / (double)totalCount);
                            }
                        }
                        rs.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        finally {
            stmt.close();
            ConnectionManager.getInstance().returnJdbcConnection(sock);
        }
        result.setAnalysisContentId(contentBean.getId());
        return result;
    }

    private static List<String> prepareQueries(Table table, Column column) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < queries.length) {
            String s = new String(queries[i].replace("$column", column.getName()).replace("$table", table.getName()));
            result.add(s);
            ++i;
        }
        return result;
    }

    public static HashMap<AnalysisContentBean, AnalysisResultBean> executeFullAnalysis(Date currentDate, Connection connection, AnalysisInfoBean infoBean) throws Exception {
        HashMap<AnalysisContentBean, AnalysisResultBean> results = new HashMap<AnalysisContentBean, AnalysisResultBean>();
        AnalysisManager manager = Helper.getInstance().getAnalysisManager();
        for (AnalysisContentBean content : manager.getAllAnalysisContentFor(infoBean)) {
            try {
                results.put(content, AnalysisExecutor.executeAnalysis(currentDate, connection, content));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private static List<AnalysisConditionResult> executeForRuleSet(Date currentDate, Connection connection, AnalysisContentBean contentBean, RuleSetBean ruleSet) throws Exception {
        int totalDistinctCountValue;
        String distinctTotalCount;
        String distinctValidCount;
        int totalCountValue;
        String totalCount;
        ResultSet rs;
        Object validCount;
        AnalysisConditionResult condRes;
        ArrayList<AnalysisConditionResult> results = new ArrayList<AnalysisConditionResult>();
        List<Table> tables = null;
        tables = connection.getTables().isEmpty() ? connection.connect() : connection.getTables();
        Table table = null;
        Column column = null;
        block0: for (Table t : tables) {
            if (!t.getLabel().equals(contentBean.getTableName())) continue;
            table = t;
            for (Column c : t.getColumns()) {
                if (!c.getLabel().equals(contentBean.getColumnName())) continue;
                column = c;
                break block0;
            }
        }
        boolean isString = false;
        if (column.getType().contains("CHAR") || column.getType().contains("char") || column.getType().contains("text") || column.getType().contains("TEXT") || column.getType().contains("DATE") || column.getType().contains("date") || column.getType().contains("time") || column.getType().contains("TIME") || column.getType().contains("STRING") || column.getType().contains("string")) {
            isString = true;
        }
        AnalysisManager manager = Helper.getInstance().getAnalysisManager();
        VanillaJdbcConnection sock = connection.getJdbcConnection();
        VanillaPreparedStatement stmt = sock.createStatement();
        List<Condition> allConditions = manager.getConditionForRuleSet(ruleSet);
        for (Condition cond : allConditions) {
            condRes = new AnalysisConditionResult();
            condRes.setConditionId(cond.getId());
            condRes.setDate(currentDate);
            validCount = new String(queries[9]);
            validCount = String.valueOf(validCount) + cond.getSql(isString);
            validCount = ((String)validCount).replace("$column", column.getName()).replace("$table", table.getName());
            rs = stmt.executeQuery((String)validCount);
            rs.next();
            condRes.setValidCount(rs.getInt(1));
            rs.close();
            totalCount = new String(queries[9]);
            totalCount = countQuery.replace("$column", column.getName()).replace("$table", table.getName());
            rs = stmt.executeQuery(totalCount);
            rs.next();
            totalCountValue = rs.getInt(1);
            rs.close();
            condRes.setValidCountPercent((double)condRes.getValidCount().intValue() / (double)totalCountValue);
            distinctValidCount = new String(distinctCountQuery);
            distinctValidCount = String.valueOf(distinctValidCount) + cond.getSql(isString);
            distinctValidCount = distinctValidCount.replace("$column", column.getName()).replace("$table", table.getName());
            rs = stmt.executeQuery(distinctValidCount);
            rs.next();
            condRes.setDistinctValidCount(rs.getInt(1));
            rs.close();
            distinctTotalCount = new String(distinctCountQuery);
            distinctTotalCount = distinctCountQuery.replace("$column", column.getName()).replace("$table", table.getName());
            rs = stmt.executeQuery(distinctTotalCount);
            rs.next();
            totalDistinctCountValue = rs.getInt(1);
            rs.close();
            condRes.setDictinctValidPercent((double)condRes.getDistinctValidCount().intValue() / (double)totalDistinctCountValue);
            results.add(condRes);
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Condition c : allConditions) {
            if (first) {
                first = false;
                buf.append(" where ");
            } else {
                buf.append(ruleSet.getLogicalOperator() == 0 ? " AND " : " OR ");
            }
            buf.append(c.getSql(isString).substring(6));
        }
        condRes = new AnalysisConditionResult();
        condRes.setDate(currentDate);
        condRes.setConditionId(0);
        validCount = new String(queries[9]);
        validCount = String.valueOf(validCount) + buf.toString();
        validCount = ((String)validCount).replace("$column", column.getName()).replace("$table", table.getName());
        rs = stmt.executeQuery((String)validCount);
        rs.next();
        condRes.setValidCount(rs.getInt(1));
        rs.close();
        totalCount = new String(queries[9]);
        totalCount = countQuery.replace("$column", column.getName()).replace("$table", table.getName());
        rs = stmt.executeQuery(totalCount);
        rs.next();
        totalCountValue = rs.getInt(1);
        rs.close();
        condRes.setValidCountPercent((double)condRes.getValidCount().intValue() / (double)totalCountValue);
        distinctValidCount = new String(distinctCountQuery);
        distinctValidCount = String.valueOf(distinctValidCount) + buf.toString();
        distinctValidCount = distinctValidCount.replace("$column", column.getName()).replace("$table", table.getName());
        rs = stmt.executeQuery(distinctValidCount);
        rs.next();
        condRes.setDistinctValidCount(rs.getInt(1));
        rs.close();
        distinctTotalCount = new String(distinctCountQuery);
        distinctTotalCount = distinctCountQuery.replace("$column", column.getName()).replace("$table", table.getName());
        rs = stmt.executeQuery(distinctTotalCount);
        rs.next();
        totalDistinctCountValue = rs.getInt(1);
        rs.close();
        condRes.setDictinctValidPercent((double)condRes.getDistinctValidCount().intValue() / (double)totalDistinctCountValue);
        condRes.setConditionId(-1);
        results.add(condRes);
        condRes.setRuleSetId(ruleSet.getId());
        stmt.close();
        ConnectionManager.getInstance().returnJdbcConnection(sock);
        return results;
    }

    public static HashMap<AnalysisContentBean, HashMap<RuleSetBean, List<AnalysisConditionResult>>> executeAnalysisForConditions(Date currentDate, Connection connection, AnalysisInfoBean infoBean) throws Exception {
        HashMap<AnalysisContentBean, HashMap<RuleSetBean, List<AnalysisConditionResult>>> results = new HashMap<AnalysisContentBean, HashMap<RuleSetBean, List<AnalysisConditionResult>>>();
        AnalysisManager manager = Helper.getInstance().getAnalysisManager();
        for (AnalysisContentBean content : manager.getAllAnalysisContentFor(infoBean)) {
            results.put(content, new HashMap());
            for (RuleSetBean rsb : manager.getRuleSetsFor(content)) {
                results.get(content).put(rsb, AnalysisExecutor.executeForRuleSet(currentDate, connection, content, rsb));
            }
        }
        return results;
    }
}

