/*
 * Decompiled with CFR 0.152.
 */
package bpm.profiling.database;

import bpm.profiling.database.AnalysisManager;
import bpm.profiling.database.ConnectionManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Helper {
    private static Helper instance = null;
    private ConnectionManager connectionManager;
    private AnalysisManager queryManager;
    private String url;
    private String user;
    private String password;
    private String driverClass;

    private Helper() throws Exception {
        try {
            BasicDataSource ds;
            ClassPathResource configFile = new ClassPathResource("/bpm/profiling/runtime/bpm.profiling.context.xml", Helper.class.getClassLoader());
            XmlBeanFactory factory = new XmlBeanFactory((Resource)configFile);
            try {
                PropertyPlaceholderConfigurer cfg = new PropertyPlaceholderConfigurer();
                cfg.setLocation((Resource)new FileSystemResource(System.getProperty("bpm.vanilla.configurationFile")));
                cfg.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.connectionManager = (ConnectionManager)factory.getBean("connectionManager");
            this.queryManager = (AnalysisManager)factory.getBean("analysisManager");
            if (factory.getBean("dataSource") instanceof BasicDataSource) {
                ds = (BasicDataSource)factory.getBean("dataSource");
                this.url = ds.getUrl();
                this.user = ds.getUsername();
                this.password = ds.getPassword();
                this.driverClass = ds.getDriverClassName();
            } else if (factory.getBean("dataSource") instanceof ComboPooledDataSource) {
                ds = (ComboPooledDataSource)factory.getBean("dataSource");
                this.url = ds.getJdbcUrl();
                this.user = ds.getUser();
                this.password = ds.getPassword();
                this.driverClass = ds.getDriverClass();
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            throw new Exception(x);
        }
    }

    public static Helper getInstance() throws Exception {
        if (instance == null) {
            instance = new Helper();
        }
        return instance;
    }

    public final ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public final AnalysisManager getAnalysisManager() {
        return this.queryManager;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }
}

