/*
 * Decompiled with CFR 0.152.
 */
package bpm.profiling.database;

import bpm.profiling.database.bean.AnalysisConditionResult;
import bpm.profiling.database.bean.AnalysisContentBean;
import bpm.profiling.database.bean.AnalysisInfoBean;
import bpm.profiling.database.bean.AnalysisResultBean;
import bpm.profiling.database.bean.RuleSetBean;
import bpm.profiling.database.bean.TagBean;
import bpm.profiling.database.dao.AnalysisContentDAO;
import bpm.profiling.database.dao.AnalysisInfoDao;
import bpm.profiling.database.dao.AnalysisResultDao;
import bpm.profiling.database.dao.ConditionDao;
import bpm.profiling.database.dao.ConditionResultDao;
import bpm.profiling.database.dao.RuleSetDao;
import bpm.profiling.database.dao.TagDao;
import bpm.profiling.runtime.core.Column;
import bpm.profiling.runtime.core.Condition;
import bpm.profiling.runtime.core.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class AnalysisManager {
    private AnalysisContentDAO contentDao;
    private AnalysisInfoDao infoDao;
    private AnalysisResultDao resultDao;
    private RuleSetDao ruleSetDao;
    private ConditionDao conditionDao;
    private ConditionResultDao conditionResultDao;
    private TagDao tagDao;

    public TagDao getTagDao() {
        return this.tagDao;
    }

    public void setTagDao(TagDao tagDao) {
        this.tagDao = tagDao;
    }

    public ConditionResultDao getConditionResultDao() {
        return this.conditionResultDao;
    }

    public void setConditionResultDao(ConditionResultDao conditionResultDao) {
        this.conditionResultDao = conditionResultDao;
    }

    public ConditionDao getConditionDao() {
        return this.conditionDao;
    }

    public void setConditionDao(ConditionDao conditionDao) {
        this.conditionDao = conditionDao;
    }

    public RuleSetDao getRuleSetDao() {
        return this.ruleSetDao;
    }

    public void setRuleSetDao(RuleSetDao ruleSetDao) {
        this.ruleSetDao = ruleSetDao;
    }

    public AnalysisContentDAO getContentDao() {
        return this.contentDao;
    }

    public void setContentDao(AnalysisContentDAO contentDao) {
        this.contentDao = contentDao;
    }

    public AnalysisInfoDao getInfoDao() {
        return this.infoDao;
    }

    public void setInfoDao(AnalysisInfoDao infoDao) {
        this.infoDao = infoDao;
    }

    public AnalysisResultDao getResultDao() {
        return this.resultDao;
    }

    public void setResultDao(AnalysisResultDao resultDao) {
        this.resultDao = resultDao;
    }

    public boolean createAnalysis(AnalysisInfoBean bean) {
        try {
            this.infoDao.add(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateAnalysis(AnalysisInfoBean bean) {
        try {
            this.infoDao.update(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteAnalysis(AnalysisInfoBean bean) {
        for (AnalysisContentBean c : this.getAllAnalysisContentFor(bean)) {
            this.deleteAnalysisContent(c);
        }
        this.infoDao.delete(bean);
        return true;
    }

    public List<AnalysisInfoBean> getAllAnalysis() {
        return this.infoDao.getAll();
    }

    public boolean createAnalysisContent(AnalysisContentBean bean) {
        try {
            this.contentDao.add(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateAnalysisContent(AnalysisContentBean bean) {
        try {
            this.contentDao.update(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteAnalysisContent(AnalysisContentBean bean) {
        List<AnalysisResultBean> l = this.resultDao.getFor(bean);
        for (AnalysisResultBean r : l) {
            this.resultDao.delete(r);
        }
        List<RuleSetBean> lr = this.getRuleSetsFor(bean);
        for (RuleSetBean rs : lr) {
            this.deleteRuleSet(rs);
        }
        try {
            this.contentDao.delete(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteRuleSet(RuleSetBean rs) {
        List<AnalysisConditionResult> l = this.conditionResultDao.getAll();
        for (AnalysisConditionResult r : l) {
            if (r.getRuleSetId() == null || rs.getId() != r.getRuleSetId().intValue()) continue;
            try {
                this.conditionResultDao.delete(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Condition c : this.getConditionForRuleSet(rs)) {
            try {
                this.conditionDao.delete(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ruleSetDao.delete(rs);
    }

    public List<AnalysisContentBean> getAllAnalysisContentFor(AnalysisInfoBean analysisInfo) {
        return this.contentDao.getFor(analysisInfo);
    }

    public boolean createAnalysisResult(AnalysisResultBean bean) {
        try {
            this.resultDao.save(bean);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<AnalysisResultBean> getAllAnalysisContentFor(AnalysisContentBean analysisContent) {
        return this.resultDao.getFor(analysisContent);
    }

    public List<RuleSetBean> getRuleSetsFor(AnalysisContentBean content) {
        return this.ruleSetDao.getForContent(content);
    }

    public RuleSetBean getRuleSetFor(int id) {
        return this.ruleSetDao.getById(id);
    }

    public List<RuleSetBean> getRuleSetsFor(Column col, AnalysisInfoBean infos) {
        AnalysisContentBean content = null;
        for (AnalysisContentBean a : this.getAllAnalysisContentFor(infos)) {
            if (!a.getColumnName().equals(col.getLabel()) || !a.getTableName().equals(col.getTable().getLabel())) continue;
            content = a;
            break;
        }
        if (content == null) {
            return new ArrayList<RuleSetBean>();
        }
        return this.ruleSetDao.getForContent(content);
    }

    public void createRuleSet(Column col, AnalysisInfoBean infos, RuleSetBean ruleSetBean) throws Exception {
        AnalysisContentBean content = null;
        for (AnalysisContentBean a : this.getAllAnalysisContentFor(infos)) {
            if (!a.getColumnName().equals(col.getLabel()) || !a.getTableName().equals(col.getTable().getLabel())) continue;
            content = a;
            break;
        }
        if (content == null) {
            throw new Exception("Cannot create a ruleSet on a Column if the have not been saved in the analysis before");
        }
        ruleSetBean.setAnalysisContentId(content.getId());
        try {
            this.ruleSetDao.add(ruleSetBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Condition> getConditionForRuleSet(RuleSetBean r) {
        return this.conditionDao.getAllFor(r);
    }

    public void createCondition(Condition c) throws Exception {
        this.conditionDao.add(c);
    }

    public void deleteCondition(Condition c) throws Exception {
        for (AnalysisConditionResult r : this.conditionResultDao.getAllFor(c)) {
            this.deleteAnalysisConditionResult(r);
        }
        this.conditionDao.delete(c);
    }

    public void updateCondition(Condition condition) {
        this.conditionDao.update(condition);
    }

    public void createConditionResult(AnalysisConditionResult c) throws Exception {
        this.conditionResultDao.add(c);
    }

    public void deleteAnalysisConditionResult(AnalysisConditionResult c) throws Exception {
        this.conditionResultDao.delete(c);
    }

    public Condition getConditionForId(int conditionId) {
        return this.conditionDao.getById(conditionId);
    }

    public boolean deleteConnection(Connection connection) {
        if (connection == null) {
            return false;
        }
        for (AnalysisInfoBean b : this.infoDao.getAllFor(connection)) {
            this.deleteAnalysis(b);
        }
        return true;
    }

    public void updateRuleSet(RuleSetBean ruleSetBean) {
        try {
            this.ruleSetDao.update(ruleSetBean);
        }
        catch (Exception exception) {}
    }

    public void createTag(TagBean tag) throws Exception {
        this.tagDao.add(tag);
    }

    public AnalysisContentBean getAllAnalysisContent(int analysisContentId) {
        return this.contentDao.getById(analysisContentId);
    }

    public List<Date> getAnalysisDatesFor(AnalysisInfoBean parentElement) {
        ArrayList<Date> l = new ArrayList<Date>();
        for (AnalysisContentBean c : this.contentDao.getFor(parentElement)) {
            for (AnalysisResultBean b : this.resultDao.getFor(c)) {
                Date d = b.getCreation();
                boolean everAdded = false;
                for (Date e : l) {
                    if (!e.equals(d)) continue;
                    everAdded = true;
                }
                if (everAdded) continue;
                l.add(d);
            }
        }
        return l;
    }

    public AnalysisResultBean getAnalysisResultsFor(AnalysisContentBean content, Date date) {
        return this.resultDao.getFor(content, date);
    }

    public List<AnalysisConditionResult> getConditionResultFor(int conditionId, Date date) {
        return this.conditionResultDao.getFor(conditionId, date);
    }

    public List<TagBean> getTagsFor(AnalysisResultBean analysisResultBean) {
        return this.tagDao.getAllForResult(analysisResultBean);
    }

    public List<TagBean> getTagsFor(AnalysisConditionResult v) {
        return this.tagDao.getAllForConditionResult(v);
    }

    public List<AnalysisConditionResult> getConditionResultFor(RuleSetBean rsB, Date date) {
        return this.conditionResultDao.getFor(rsB, date);
    }
}

