/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.runtime.model;

import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableColumn;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableModel;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableRow;
import java.util.ArrayList;

public class OdaGoogleTableParameter {
    private String paramColumn;
    private String paramOperator;
    private String paramLogicalOperator;
    private String paramName;
    private Class paramClass;
    private Object paramValue1;
    private static ArrayList<Integer> listIndexRowsHiddenFirst;
    private static ArrayList<Integer> listIndexRowsHiddenNext;
    private static ArrayList<Integer> listIndexRowsHiddenFinal;
    public static final String QUERY_NO_FILTER = "++No filter++";
    public static final String QUERY_NO_LOGICAL = "++No Logical++";
    public static final String QUERY_NO_PARAMETER = "++No Parameter++";
    public static final String QUERY_FILTER_NO_VALUES = "++Any Value++";
    public static final String SEPARATOR_QUERY = ";";
    public static final String SEPARATOR_COLUMN_FILTER = ":";
    public static final String[] OPERATORS_TAB;
    public static final int OPERATORS_INDEX_EQUALS = 0;
    public static final int OPERATORS_INDEX_NOT_EQUALS = 1;
    public static final int OPERATORS_INDEX_LESS = 2;
    public static final int OPERATORS_INDEX_LESS_EQUALS = 3;
    public static final int OPERATORS_INDEX_GREATHER = 4;
    public static final int OPERATORS_INDEX_GREATHER_EQUALS = 5;
    public static final int OPERATORS_INDEX_BETWEEN = 6;
    public static final int OPERATORS_INDEX_BETWEEN_NOT = 7;
    public static final int OPERATORS_INDEX_NULL = 8;
    public static final int OPERATORS_INDEX_NULL_NOT = 9;
    public static final int OPERATORS_INDEX_TRUE = 10;
    public static final int OPERATORS_INDEX_FALSE = 11;
    public static final String[] LOGICAL_OPERATORS_TAB;
    public static final int LOGICAL_INDEX_NONE = 0;
    public static final int LOGICAL_INDEX_AND = 1;
    public static final int LOGICAL_INDEX_OR = 2;

    static {
        OPERATORS_TAB = new String[]{"Equals to", "Not equals to", "Less than", "Less than or Equal", "Greather than", "Greather than or equal", "Between", "Not between", "Is null", "Is not null", "Is true", "Is false"};
        LOGICAL_OPERATORS_TAB = new String[]{"", "AND", "OR"};
    }

    public OdaGoogleTableParameter() {
    }

    public OdaGoogleTableParameter(String colParameter, String opeParameter, Class classParameter, String opeLogical) {
        this.paramColumn = colParameter;
        this.paramOperator = opeParameter;
        this.paramLogicalOperator = opeLogical;
        this.paramName = "";
        this.paramClass = classParameter;
        this.paramValue1 = null;
    }

    public OdaGoogleTableParameter(String colP, String opP) {
        this.paramColumn = colP;
        this.paramOperator = opP;
    }

    public static void updateDataSetWithParameters(OdaGoogleTableModel tableSelected, ArrayList<OdaGoogleTableParameter> listQueryParameters) {
        listIndexRowsHiddenFirst = new ArrayList();
        listIndexRowsHiddenNext = new ArrayList();
        listIndexRowsHiddenFinal = new ArrayList();
        for (OdaGoogleTableParameter currentParam : listQueryParameters) {
            listIndexRowsHiddenFirst.clear();
            listIndexRowsHiddenFirst.addAll(listIndexRowsHiddenFinal);
            listIndexRowsHiddenNext.clear();
            int indexCurrentRow = 0;
            for (OdaGoogleTableRow currentRow : tableSelected.getListRows()) {
                OdaGoogleTableParameter.applyCurrentParameter(currentParam, currentRow, tableSelected, indexCurrentRow);
                ++indexCurrentRow;
            }
            OdaGoogleTableParameter.applyLogicalFilter(currentParam.paramLogicalOperator);
        }
        int subIndexRow = 0;
        for (OdaGoogleTableRow rowUpdate : tableSelected.getListRows()) {
            if (listIndexRowsHiddenFinal.contains(subIndexRow)) {
                rowUpdate.setFiltered(true);
            } else {
                rowUpdate.setFiltered(false);
            }
            ++subIndexRow;
        }
    }

    private static void applyLogicalFilter(String paramLogicalOperator2) {
        listIndexRowsHiddenFinal.clear();
        if (paramLogicalOperator2.equals(QUERY_NO_LOGICAL) || paramLogicalOperator2.equals(LOGICAL_OPERATORS_TAB[1])) {
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenFirst);
            for (Integer rowNext : listIndexRowsHiddenNext) {
                if (listIndexRowsHiddenFinal.contains(rowNext)) continue;
                listIndexRowsHiddenFinal.add(rowNext);
            }
        } else {
            listIndexRowsHiddenFirst.retainAll(listIndexRowsHiddenNext);
            listIndexRowsHiddenNext.retainAll(listIndexRowsHiddenFirst);
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenNext);
        }
    }

    private static void applyCurrentParameter(OdaGoogleTableParameter currentParam, OdaGoogleTableRow currentRow, OdaGoogleTableModel sheetSelected, int indexCurrentRow) {
        String indexOperatorFilter = currentParam.getParamOperator();
        String valueCell = null;
        Class classColConcerned = null;
        int indexColConcerned = 0;
        boolean valueOk = false;
        for (OdaGoogleTableColumn col : sheetSelected.getListColumns()) {
            if (!col.getColName().equals(currentParam.getParamColumn())) continue;
            indexColConcerned = col.getColIndex();
            classColConcerned = col.getColClass();
        }
        try {
            if (classColConcerned == Integer.class) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                Integer.parseInt(valueCell);
                valueOk = true;
            } else if (classColConcerned == Double.class) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                Double.parseDouble(valueCell);
                valueOk = true;
            } else {
                valueOk = true;
            }
        }
        catch (Exception exception) {
            valueOk = false;
        }
        if (!valueOk) {
            currentRow.setFiltered(true);
        } else if (currentParam.getParamValue1() != null) {
            String value1;
            if (indexOperatorFilter.equals(OPERATORS_TAB[2])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) < 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[3])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) <= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[4])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) > 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[5])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) >= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[0])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) == 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[1])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleTableParameter.objCompareTo(classColConcerned, valueCell, value1) != 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[8])) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(false);
                } else if (valueCell.toString().equals("0") || valueCell.toString().equals("0.0")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[9])) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell != null) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[10])) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("true")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[11])) {
                valueCell = currentRow.getListCells().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("false")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
        }
        if (currentRow.isFiltered()) {
            listIndexRowsHiddenNext.add(indexCurrentRow);
        }
    }

    private static int objCompareTo(Class classObj, String valueData, String valueFilter1) {
        int resultCompare = 0;
        if (classObj == Integer.class) {
            Integer intValueFilter1 = Integer.valueOf(valueFilter1);
            Integer intValueData = Integer.valueOf(valueData.toString());
            resultCompare = intValueData.compareTo(intValueFilter1);
        } else if (classObj == Double.class) {
            Double doubleValueFilter1 = Double.valueOf(valueFilter1);
            Double doubleValueData = Double.valueOf(valueData.toString());
            resultCompare = doubleValueData.compareTo(doubleValueFilter1);
        } else {
            String strValueData = valueData.toString();
            resultCompare = strValueData.compareTo(valueFilter1);
        }
        return resultCompare;
    }

    public String getParamColumn() {
        return this.paramColumn;
    }

    public void setParamColumn(String paramColumn) {
        this.paramColumn = paramColumn;
    }

    public String getParamOperator() {
        return this.paramOperator;
    }

    public void setParamOperator(String paramOperator) {
        this.paramOperator = paramOperator;
    }

    public Class getParamClass() {
        return this.paramClass;
    }

    public void setParamClass(Class paramClass) {
        this.paramClass = paramClass;
    }

    public Object getParamValue1() {
        return this.paramValue1;
    }

    public void setParamValue1(Object paramValue1) {
        this.paramValue1 = paramValue1;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}

