/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.runtime.impl;

import bpm.google.table.oda.driver.runtime.impl.ResultSetMetaData;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableModel;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private int m_maxRows;
    private int m_currentRowId;
    private ResultSetMetaData metaData;
    private OdaGoogleTableModel tableSelect;

    public ResultSet(OdaGoogleTableModel tableSelected, ResultSetMetaData resultSetMetaData) {
        this.tableSelect = tableSelected;
        this.metaData = resultSetMetaData;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.metaData;
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = this.tableSelect.getTableCountRow();
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    public boolean next() throws OdaException {
        int maxRows = this.getMaxRows();
        if (maxRows <= 0) {
            maxRows = 5;
        }
        if (this.m_currentRowId < maxRows) {
            ++this.m_currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.m_currentRowId = 0;
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        return this.tableSelect.getListRows().get(this.m_currentRowId - 1).getListCells().get(index - 1);
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        String obj = this.tableSelect.getListRows().get(this.m_currentRowId - 1).getListCells().get(index - 1);
        int cellToInt = 0;
        try {
            cellToInt = Integer.parseInt(obj.toString());
            return cellToInt;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        String obj = this.tableSelect.getListRows().get(this.m_currentRowId - 1).getListCells().get(index - 1);
        double cellToDouble = 0.0;
        try {
            cellToDouble = Double.parseDouble(obj.toString());
            return cellToDouble;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        int columnId = 1;
        if (columnName == null || columnName.length() == 0) {
            return columnId;
        }
        String lastChar = columnName.substring(columnName.length() - 1, 1);
        try {
            columnId = Integer.parseInt(lastChar);
        }
        catch (NumberFormatException numberFormatException) {}
        return columnId;
    }

    public Object getObject(int index) throws OdaException {
        String obj = this.tableSelect.getListRows().get(this.m_currentRowId - 1).getListCells().get(index - 1);
        return obj;
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }
}

