/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.runtime.impl;

import bpm.google.table.oda.driver.runtime.impl.DataSetMetaData;
import bpm.google.table.oda.driver.runtime.impl.Query;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableColumn;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableModel;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableRow;
import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    private boolean m_isOpen = false;
    private static final String QUERY_SELECT_ALL = "SELECT * FROM ";
    public static final String QUERY_COUNT_ALL = "SELECT COUNT() FROM ";
    public static final String URL_TABLE = "http://tables.googlelabs.com/api/query";
    public static final Pattern CSV_VALUE_PATTERN = Pattern.compile("([^,\\r\\n\"]*|\"(([^\"]*\"\")*[^\"]*)\")(,|\\r?\\n)");
    public static final String P_USER = "P_USER";
    public static final String P_PASS = "P_PASS";
    public static final String P_ID_TABLE = "P_ID_TABLE";
    public static final String P_COLUMN_NAME = "P_COLUMN_NAME";
    public static final String P_COLUMN_TYPE = "P_COLUMN_TYPE";
    public static final String P_COLUMN_COUNT = "P_COLUMN_COUNT";
    public static final String P_ROW_COUNT = "P_ROW_COUNT";
    public static final String PROPERTIES_SEPARATOR = ";";
    private String user;
    private String pass;
    private String idTable;
    private String colNames;
    private String colTypes;
    private String colCount;
    private String rowCount;
    private GoogleService service;
    private OdaGoogleTableModel tableSelected;
    private ArrayList<String> listAllValues;

    public void open(Properties connProperties) throws OdaException {
        if (connProperties == null) {
            throw new OdaException("No Connection Properties Provided.");
        }
        boolean hasChanged = false;
        if (this.user == null || !this.user.equals(connProperties.getProperty(P_USER))) {
            this.user = connProperties.getProperty(P_USER);
            hasChanged = true;
        }
        if (this.pass == null || !this.pass.equals(connProperties.getProperty(P_PASS))) {
            this.pass = connProperties.getProperty(P_PASS);
            hasChanged = true;
        }
        if (this.idTable == null || !this.idTable.equals(connProperties.getProperty(P_ID_TABLE))) {
            this.idTable = connProperties.getProperty(P_ID_TABLE);
            hasChanged = true;
        }
        if (this.colNames == null || !this.colNames.equals(connProperties.getProperty(P_COLUMN_NAME))) {
            this.colNames = connProperties.getProperty(P_COLUMN_NAME);
            hasChanged = true;
        }
        if (this.colTypes == null || !this.colTypes.equals(connProperties.getProperty(P_COLUMN_TYPE))) {
            this.colTypes = connProperties.getProperty(P_COLUMN_TYPE);
            hasChanged = true;
        }
        if (this.colCount == null || !this.colCount.equals(connProperties.getProperty(P_COLUMN_COUNT))) {
            this.colCount = connProperties.getProperty(P_COLUMN_COUNT);
            hasChanged = true;
        }
        if (this.rowCount == null || !this.rowCount.equals(connProperties.getProperty(P_ROW_COUNT))) {
            this.rowCount = connProperties.getProperty(P_ROW_COUNT);
            hasChanged = true;
        }
        if (!hasChanged) {
            this.m_isOpen = true;
            return;
        }
        try {
            this.service = new GoogleService("fusiontables", "fusiontables");
            this.service.setUserCredentials(this.user, this.pass, ClientLoginAccountType.GOOGLE);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        this.getAllDatas();
        if (this.listAllValues != null) {
            this.tableSelected = new OdaGoogleTableModel();
            ArrayList<OdaGoogleTableColumn> listColumnTemp = new ArrayList<OdaGoogleTableColumn>();
            String[] tabColNames = this.colNames.split(PROPERTIES_SEPARATOR);
            String[] tabColTypes = this.colTypes.split(PROPERTIES_SEPARATOR);
            int i = 0;
            while (i < Integer.valueOf(this.colCount)) {
                listColumnTemp.add(new OdaGoogleTableColumn(tabColNames[i], tabColTypes[i], i));
                ++i;
            }
            this.tableSelected.setListColumns(listColumnTemp);
            this.tableSelected.setTableCountCol(listColumnTemp.size());
            this.tableSelected.setTableCountRow(Integer.valueOf(this.rowCount));
            int countRowToRemoved = this.listAllValues.size() / this.tableSelected.getTableCountCol() - this.tableSelected.getTableCountRow();
            int countCellsToRemoved = countRowToRemoved * this.tableSelected.getTableCountCol();
            ArrayList<String> tempListString = new ArrayList<String>();
            int i2 = 0;
            while (i2 < countCellsToRemoved) {
                tempListString.add(this.listAllValues.get(i2));
                ++i2;
            }
            this.listAllValues.removeAll(tempListString);
            int indexRow = 0;
            int sizeListValues = this.listAllValues.size();
            int tableColCount = this.tableSelected.getTableCountCol();
            tempListString.clear();
            while (indexRow < sizeListValues) {
                int indexCol = 0;
                while (indexCol < tableColCount) {
                    tempListString.add(this.listAllValues.get(indexRow + indexCol));
                    ++indexCol;
                }
                this.tableSelected.getListRows().add(new OdaGoogleTableRow(tempListString, false));
                tempListString.clear();
                indexRow += tableColCount;
            }
            this.preciseColumnType();
        }
        this.m_isOpen = true;
    }

    protected void getAllDatas() {
        try {
            String querySelect = QUERY_SELECT_ALL + this.idTable;
            URL url = new URL("http://tables.googlelabs.com/api/query?sql=" + URLEncoder.encode(querySelect, "UTF-8"));
            Service.GDataRequest request = this.service.getRequestFactory().getRequest(Service.GDataRequest.RequestType.QUERY, url, ContentType.TEXT_PLAIN);
            request.execute();
            this.listAllValues = new ArrayList();
            Scanner scanner = new Scanner(request.getResponseStream());
            while (scanner.hasNextLine()) {
                scanner.findWithinHorizon(CSV_VALUE_PATTERN, 0);
                MatchResult match = scanner.match();
                String quotedString = match.group(2);
                String decoded = quotedString == null ? match.group(1) : quotedString.replaceAll("\"\"", "\"");
                this.listAllValues.add(decoded);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this.tableSelected);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public OdaGoogleTableModel getTableSelected() {
        return this.tableSelected;
    }

    public void setTableSelected(OdaGoogleTableModel tableSelected) {
        this.tableSelected = tableSelected;
    }

    private void preciseColumnType() {
        if (this.tableSelected != null) {
            String fullCell = null;
            for (OdaGoogleTableColumn col : this.tableSelected.getListColumns()) {
                if (!col.getColClass().equals(Number.class)) continue;
                int i = 0;
                String cellTemp = "";
                boolean cellNotNull = false;
                while (!cellNotNull && i < this.tableSelected.getTableCountRow()) {
                    cellTemp = this.tableSelected.getListRows().get(i).getListCells().get(col.getColIndex());
                    if (cellTemp != null && cellTemp.length() != 0) {
                        cellNotNull = true;
                        fullCell = cellTemp;
                    }
                    ++i;
                }
                if (fullCell.contains(".")) {
                    col.setColClass(Double.class);
                    continue;
                }
                col.setColClass(Integer.class);
            }
        }
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

