/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.oda.runtime.impl;

import bpm.vanilla.map.core.design.fusionmap.IFusionMapSpecificationEntity;
import bpm.vanilla.map.oda.runtime.impl.ResultSetMetaData;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private int m_maxRows;
    private int m_currentRowId = -1;
    private List<IFusionMapSpecificationEntity> rows;

    public ResultSet(List<IFusionMapSpecificationEntity> rows) {
        this.rows = rows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return new ResultSetMetaData();
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    public boolean next() throws OdaException {
        int maxRows = this.getMaxRows();
        if (maxRows <= 0) {
            if (this.m_currentRowId < this.rows.size()) {
                ++this.m_currentRowId;
                return this.m_currentRowId < this.rows.size();
            }
        } else if (this.m_currentRowId < maxRows && this.m_currentRowId < this.rows.size()) {
            ++this.m_currentRowId;
            return this.m_currentRowId < this.rows.size();
        }
        return false;
    }

    public void close() throws OdaException {
        this.rows.clear();
        this.rows = null;
        this.m_currentRowId = 0;
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        try {
            switch (index) {
                case 1: {
                    return String.valueOf(this.rows.get(this.m_currentRowId).getId());
                }
                case 2: {
                    return String.valueOf(this.rows.get(this.m_currentRowId).getFusionMapObjectId());
                }
                case 3: {
                    return this.rows.get(this.m_currentRowId).getFusionMapInternalId();
                }
                case 4: {
                    return this.rows.get(this.m_currentRowId).getFusionMapShortName();
                }
                case 5: {
                    return this.rows.get(this.m_currentRowId).getFusionMapLongName();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new OdaException((Throwable)ex);
        }
        throw new OdaException("Index out of bounds " + index);
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        Long l = null;
        switch (index) {
            case 1: {
                l = this.rows.get(this.m_currentRowId).getId();
            }
            case 2: {
                l = this.rows.get(this.m_currentRowId).getFusionMapObjectId();
            }
        }
        if (l != null) {
            return l.intValue();
        }
        throw new OdaException("Index " + index + " not an Integer");
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        switch (index) {
            case 1: {
                return this.rows.get(this.m_currentRowId).getId();
            }
            case 2: {
                return this.rows.get(this.m_currentRowId).getFusionMapObjectId();
            }
            case 3: {
                return this.rows.get(this.m_currentRowId).getFusionMapInternalId();
            }
            case 4: {
                return this.rows.get(this.m_currentRowId).getFusionMapShortName();
            }
            case 5: {
                return this.rows.get(this.m_currentRowId).getFusionMapLongName();
            }
        }
        throw new OdaException("Index out of bounds " + index);
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        int columnId = 1;
        if (columnName == null || columnName.length() == 0) {
            return columnId;
        }
        String lastChar = columnName.substring(columnName.length() - 1, 1);
        try {
            columnId = Integer.parseInt(lastChar);
        }
        catch (NumberFormatException numberFormatException) {}
        return columnId;
    }
}

