/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.oda.runtime.impl;

import bpm.vanilla.map.core.design.fusionmap.IFusionMapRegistry;
import bpm.vanilla.map.oda.runtime.impl.DataSetMetaData;
import bpm.vanilla.map.oda.runtime.impl.Query;
import bpm.vanilla.map.remote.core.design.impl.RemoteFusionMapRegistry;
import com.ibm.icu.util.ULocale;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    public static final String VANILLA_RUNTIME_URL = "bpm.vanilla.map.oda.runtime.vanillaRuntimeServerUrl";
    private boolean m_isOpen = false;
    private IFusionMapRegistry fusionMapRegistry;

    public void open(Properties connProperties) throws OdaException {
        String vanillaRuntimeUrl = connProperties.getProperty(VANILLA_RUNTIME_URL);
        if (vanillaRuntimeUrl == null) {
            throw new OdaException("Missing VanillaRuntimeUrl in OdaConnection properties");
        }
        if (this.fusionMapRegistry == null) {
            this.fusionMapRegistry = new RemoteFusionMapRegistry();
            this.fusionMapRegistry.configure((Object)vanillaRuntimeUrl);
        }
        this.fusionMapRegistry.configure((Object)vanillaRuntimeUrl);
        this.m_isOpen = true;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.fusionMapRegistry = null;
        this.m_isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this.fusionMapRegistry);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

