/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.designer.ui.common.dialogs;

import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.beans.Group;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogGroupPickers
extends Dialog {
    private IVanillaAPI vanillaApi;
    private CheckboxTableViewer viewer;
    private List<Group> groups = new ArrayList<Group>();

    public DialogGroupPickers(Shell parentShell, IVanillaAPI vanillaApi) {
        super(parentShell);
        this.vanillaApi = vanillaApi;
    }

    public DialogGroupPickers(Shell parentShell, IVanillaAPI vanillaApi, List<Group> checkedGroups) {
        super(parentShell);
        this.vanillaApi = vanillaApi;
        if (this.groups != null) {
            this.groups = checkedGroups;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, true));
        main.setLayoutData((Object)new GridData(1808));
        Button checkAll = new Button(parent, 8);
        checkAll.setText("Check All");
        checkAll.setLayoutData((Object)new GridData(4, 4, true, false));
        checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogGroupPickers.this.viewer.setAllChecked(true);
                DialogGroupPickers.this.viewer.refresh();
            }
        });
        Button uncheckAll = new Button(parent, 8);
        uncheckAll.setText("Uncheck All");
        uncheckAll.setLayoutData((Object)new GridData(4, 4, true, false));
        uncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogGroupPickers.this.viewer.setAllChecked(false);
                DialogGroupPickers.this.viewer.refresh();
            }
        });
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        l.setText("Select Groups");
        this.viewer = CheckboxTableViewer.newCheckList((Composite)main, (int)2048);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        return main;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    protected void okPressed() {
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.groups.add((Group)o);
            ++n2;
        }
        super.okPressed();
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 400);
        this.getShell().setText("Select Groups");
        try {
            this.viewer.setInput((Object)this.vanillaApi.getVanillaSecurityManager().getGroups());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Group g : (List)this.viewer.getInput()) {
            for (Group gg : this.groups) {
                if (g.getId().intValue() != gg.getId().intValue()) continue;
                this.viewer.setChecked((Object)g, true);
            }
        }
        this.groups.clear();
    }
}

