/*
 * Decompiled with CFR 0.152.
 */
package bpm.gateway.ui.dwh.importer.wizard;

import bpm.gateway.core.Server;
import bpm.gateway.core.manager.ResourceManager;
import bpm.gateway.core.server.database.dwhview.DwhDbConnection;
import bpm.gateway.ui.Activator;
import bpm.gateway.ui.dwh.importer.wizard.ImporterHelper;
import bpm.gateway.ui.dwh.importer.wizard.PageImportDwhView;
import bpm.gateway.ui.dwh.importer.wizard.PageMetaDataInfos;
import bpm.model.converter.ConverterPluginManager;
import bpm.model.converter.core.IModelConverter;
import bpm.model.converter.core.IModelConverterFactory;
import bpm.sqldesigner.api.document.DocumentSnapshot;
import bpm.vanilla.repository.ui.connection.DialogConnect;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class DwwhViewImportWizard
extends Wizard
implements IImportWizard {
    private PageImportDwhView importPage;
    private PageMetaDataInfos infoPages;

    public void addPages() {
        this.importPage = new PageImportDwhView("dwhview.importpage");
        this.importPage.setTitle("SqlDesigner DwhView");
        this.importPage.setDescription("Select a DwhView from the Vanilla Repository");
        this.addPage((IWizardPage)this.importPage);
        this.infoPages = new PageMetaDataInfos("dwhview.infospage");
        this.importPage.setTitle("Vanilla MetaData Model Information");
        this.importPage.setDescription("Define generic properties for the Metadata Model and select the groups that will be allowed to access the model items.");
        this.addPage((IWizardPage)this.infoPages);
    }

    public boolean performFinish() {
        try {
            DocumentSnapshot snap = ImporterHelper.loadDwhView(this.importPage.getSelectedItem());
            IModelConverterFactory modelConverterFactory = null;
            for (IModelConverterFactory f : ConverterPluginManager.getConverterImplementers()) {
                if (!f.getTargetClassName().equals(DwhDbConnection.class.getName())) continue;
                modelConverterFactory = f;
                break;
            }
            IModelConverter converter = modelConverterFactory.createConverter();
            Object configurationObject = this.infoPages.getConfigurationContext();
            converter.configure(configurationObject);
            Server model = (Server)converter.convert((Object)snap);
            ResourceManager.getInstance().addServer(model);
            ResourceManager.getInstance().fireContentChange();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (Activator.getDefault().getRepositoryConnection() == null) {
            DialogConnect d = new DialogConnect(this.getShell());
            d.open();
            if (Activator.getDefault().getRepositoryConnection() == null) {
                this.performCancel();
            }
        }
    }
}

