/*
 * Decompiled with CFR 0.152.
 */
package bpm.gateway.ui.dwh.importer.converters;

import bpm.gateway.core.IServerConnection;
import bpm.gateway.core.server.database.DBColumn;
import bpm.gateway.core.server.database.DBSchema;
import bpm.gateway.core.server.database.DBTable;
import bpm.gateway.core.server.database.DataBaseServer;
import bpm.gateway.core.server.database.dwhview.DwhDbConnection;
import bpm.model.converter.core.IModelConverter;
import bpm.sqldesigner.api.document.DocumentSnapshot;
import bpm.sqldesigner.api.model.Column;
import bpm.sqldesigner.api.model.SchemaNull;
import bpm.sqldesigner.api.model.Table;
import java.util.ArrayList;
import java.util.Map;

public class DwhGatewayConnectionConverter
implements IModelConverter<DocumentSnapshot> {
    private static final String name = "SqlDesigner DwhView to Vanilla MetaData";
    private static final String description = "Create a Vanilla MetaData until the Business Package";
    public static final String PROP_CONNECTION_NAME = "bpm.gateway.ui.dwh.importer.converters.DwhGatewayConnectionConverter.connectionName";
    public static final String PROP_DATABASE_SERVER = "bpm.gateway.ui.dwh.importer.converters.DwhGatewayConnectionConverter.databaseServer";
    private String connectionName;
    private String databaseServerName;

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public Class<?> getTargetClass() {
        return DwhDbConnection.class;
    }

    public void configure(Object configurationObject) throws Exception {
        if (!(configurationObject instanceof Map)) {
            throw new Exception("A Map is expected to configure the Converter");
        }
        Map map = (Map)configurationObject;
        try {
            this.connectionName = (String)map.get(PROP_CONNECTION_NAME);
        }
        catch (Exception e) {
            throw new Exception("Unable to find connection name in configurationObject : " + e.getMessage(), e);
        }
        try {
            this.databaseServerName = (String)map.get(PROP_DATABASE_SERVER);
        }
        catch (Exception e) {
            throw new Exception("Unable to find database server name in configurationObject : " + e.getMessage(), e);
        }
    }

    public Object convert(DocumentSnapshot dwhView) throws Exception {
        DwhDbConnection conModel = new DwhDbConnection();
        conModel.setDriverName(dwhView.getDatabaseConnection().getDriverName());
        conModel.setHost(dwhView.getDatabaseConnection().getHost());
        conModel.setPort(dwhView.getDatabaseConnection().getPort());
        conModel.setDataBaseName(dwhView.getDatabaseConnection().getDataBaseName());
        conModel.setLogin(dwhView.getDatabaseConnection().getLogin());
        conModel.setPassword(dwhView.getDatabaseConnection().getPassword());
        new ArrayList();
        DBSchema schema = null;
        for (Table table : dwhView.getTables()) {
            if (schema == null) {
                schema = new DBSchema(table.getSchema().getName(), table.getSchema() instanceof SchemaNull);
            }
            DBTable t = new DBTable(schema, table.getName(), "Table");
            for (Column column : table.getColumns().values()) {
                new DBColumn(t, column.getName(), column.getTypeString(), column.isPrimaryKey());
            }
            conModel.setSchema(schema);
        }
        conModel.setName(this.connectionName);
        DataBaseServer server = new DataBaseServer();
        server.setDescription("Autogenerated from a DwhView import");
        server.setName(this.databaseServerName);
        server.addConnection((IServerConnection)conModel);
        server.setCurrentConnection((IServerConnection)conModel);
        return server;
    }
}

