/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.ui.impl.datasource;

import bpm.google.table.oda.driver.runtime.impl.Connection;
import bpm.google.table.oda.driver.ui.Activator;
import bpm.google.table.oda.driver.ui.dialogs.MessageTable;
import bpm.google.table.oda.driver.ui.impl.datasource.GoogleTableDataSourcePage;
import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class ConnectionComposite
extends Composite {
    private static final String QUERY_SHOW_TABLES = "SHOW TABLES";
    private static final String QUERY_DESCRIBE_TABLE = "DESCRIBE ";
    private static final String START_DESCRIPTION_COLUMN = "col";
    private GoogleService service;
    private Text login;
    private Text password;
    private List listTable;
    private Button btnOkConn;
    private ArrayList<Integer> listIDTables;
    private ArrayList<String> listNameTables;
    private ArrayList<String> listNameColumns;
    private ArrayList<String> listTypeColumn;
    private GoogleTableDataSourcePage page;

    public ConnectionComposite(Composite parent, int style, GoogleTableDataSourcePage pPage) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.page = pPage;
        this.buildContents();
    }

    private void buildContents() {
        this.listIDTables = new ArrayList();
        this.listNameTables = new ArrayList();
        this.listNameColumns = new ArrayList();
        this.listTypeColumn = new ArrayList();
        PGroup group = new PGroup((Composite)this, 65536);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 4));
        group.setText("G-Mail Connection");
        group.setImage(Activator.getDefault().getImageRegistry().get("email.png"));
        Label lblAdress = new Label((Composite)group, 0);
        lblAdress.setText("G-Mail Adress:");
        lblAdress.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.login = new Text((Composite)group, 2048);
        this.login.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblPass = new Label((Composite)group, 0);
        lblPass.setText("G-Mail Password:");
        lblPass.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.password = new Text((Composite)group, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnOkConn = new Button((Composite)group, 0);
        this.btnOkConn.setLayoutData((Object)new GridData(2, 4, true, false, 2, 1));
        this.btnOkConn.setText(" Login");
        this.btnOkConn.setImage(Activator.getDefault().getImageRegistry().get("googleDocs.png"));
        group = new PGroup((Composite)this, 65536);
        group.setText("Available Table(s)");
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 10));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setImage(Activator.getDefault().getImageRegistry().get("column.png"));
        this.listTable = new List((Composite)group, 2564);
        this.listTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.btnOkConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ConnectionComposite.this.service = new GoogleService("fusiontables", "fusiontables");
                    ConnectionComposite.this.service.setUserCredentials(ConnectionComposite.this.login.getText(), ConnectionComposite.this.password.getText(), ClientLoginAccountType.GOOGLE);
                    ConnectionComposite.this.getAllTables(ConnectionComposite.this.service);
                }
                catch (AuthenticationException authenticationException) {
                    ConnectionComposite.this.listTable.removeAll();
                    MessageTable.showError(ConnectionComposite.this.getShell(), "Unable to connect to this g-mail account. Please verify your login/password \n or if you are correctly connected to Internet.");
                }
            }
        });
        this.listTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite.this.page.setPageComplete(true);
                int idTableSelected = (Integer)ConnectionComposite.this.listIDTables.get(ConnectionComposite.this.listTable.getSelectionIndex());
                ConnectionComposite.this.getColumnDescription(ConnectionComposite.this.service, idTableSelected);
            }
        });
    }

    protected void getColumnDescription(GoogleService service2, int idTable) {
        this.listNameColumns.clear();
        this.listTypeColumn.clear();
        try {
            URL url = new URL("http://tables.googlelabs.com/api/query?sql=" + URLEncoder.encode("DESCRIBE  " + idTable, "UTF-8"));
            Service.GDataRequest request = this.service.getRequestFactory().getRequest(Service.GDataRequest.RequestType.QUERY, url, ContentType.TEXT_PLAIN);
            request.execute();
            Scanner scanner = new Scanner(request.getResponseStream());
            int indexMatchGroup = 0;
            while (scanner.hasNextLine()) {
                String decoded;
                scanner.findWithinHorizon(Connection.CSV_VALUE_PATTERN, 0);
                MatchResult match = scanner.match();
                String quotedString = match.group(2);
                String string = decoded = quotedString == null ? match.group(1) : quotedString.replaceAll("\"\"", "\"");
                if (indexMatchGroup >= 3) {
                    if (!decoded.startsWith(START_DESCRIPTION_COLUMN)) {
                        if (indexMatchGroup % 2 == 0) {
                            this.listTypeColumn.add(decoded);
                        } else {
                            this.listNameColumns.add(decoded);
                        }
                    } else {
                        ++indexMatchGroup;
                    }
                }
                ++indexMatchGroup;
            }
        }
        catch (MalformedURLException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Url error.");
            e.printStackTrace();
        }
        catch (IOException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Unexpected Error");
            e.printStackTrace();
        }
        catch (ServiceException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Google Service Error");
            e.printStackTrace();
        }
    }

    protected void getAllTables(GoogleService service2) {
        this.listTable.removeAll();
        this.listIDTables.clear();
        this.listNameTables.clear();
        try {
            URL url = new URL("http://tables.googlelabs.com/api/query?sql=" + URLEncoder.encode(QUERY_SHOW_TABLES, "UTF-8"));
            Service.GDataRequest request = this.service.getRequestFactory().getRequest(Service.GDataRequest.RequestType.QUERY, url, ContentType.TEXT_PLAIN);
            request.execute();
            Scanner scanner = new Scanner(request.getResponseStream());
            int indexMatchGroup = 0;
            while (scanner.hasNextLine()) {
                String decoded;
                scanner.findWithinHorizon(Connection.CSV_VALUE_PATTERN, 0);
                MatchResult match = scanner.match();
                String quotedString = match.group(2);
                String string = decoded = quotedString == null ? match.group(1) : quotedString.replaceAll("\"\"", "\"");
                if (indexMatchGroup >= 2) {
                    if (indexMatchGroup % 2 == 0) {
                        this.listIDTables.add(Integer.valueOf(decoded));
                    } else {
                        this.listNameTables.add(decoded);
                        this.listTable.add(decoded);
                    }
                }
                ++indexMatchGroup;
            }
        }
        catch (MalformedURLException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Url error.");
            e.printStackTrace();
        }
        catch (IOException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Unexpected Error");
            e.printStackTrace();
        }
        catch (ServiceException e) {
            MessageTable.showError(this.getShell(), "Unable to display table's List. \n Reason : Google Service Error");
            e.printStackTrace();
        }
    }

    public String getTableRowCount() {
        String result = null;
        try {
            String querySelect = "SELECT COUNT() FROM " + this.getIdTable();
            URL url = new URL("http://tables.googlelabs.com/api/query?sql=" + URLEncoder.encode(querySelect, "UTF-8"));
            Service.GDataRequest request = this.service.getRequestFactory().getRequest(Service.GDataRequest.RequestType.QUERY, url, ContentType.TEXT_PLAIN);
            request.execute();
            Scanner scanner = new Scanner(request.getResponseStream());
            while (scanner.hasNextLine()) {
                String decoded;
                scanner.findWithinHorizon(Connection.CSV_VALUE_PATTERN, 0);
                MatchResult match = scanner.match();
                String quotedString = match.group(2);
                result = decoded = quotedString == null ? match.group(1) : quotedString.replaceAll("\"\"", "\"");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void initWidgetWithPropertie(Properties profileProps) {
        if (profileProps != null) {
            this.listIDTables = new ArrayList();
            this.listNameTables = new ArrayList();
            this.listNameColumns = new ArrayList();
            this.listTypeColumn = new ArrayList();
            try {
                this.service = new GoogleService("fusiontables", "fusiontables");
                this.service.setUserCredentials(profileProps.getProperty("P_USER"), profileProps.getProperty("P_PASS"), ClientLoginAccountType.GOOGLE);
                this.getAllTables(this.service);
            }
            catch (AuthenticationException authenticationException) {
                this.listTable.removeAll();
                MessageTable.showError(this.getShell(), "Unable to connect to this g-mail account. Please verify your login/password \n or if you are correctly connected to Internet.");
            }
            this.login.setText(profileProps.getProperty("P_USER"));
            this.password.setText(profileProps.getProperty("P_PASS"));
            int idTable = Integer.valueOf(profileProps.getProperty("P_ID_TABLE"));
            boolean findIndex = false;
            int i = 0;
            int indexSelection = 0;
            while (!findIndex && i < this.listIDTables.size()) {
                if (idTable == this.listIDTables.get(i)) {
                    findIndex = true;
                    indexSelection = i;
                }
                ++i;
            }
            this.listTable.setSelection(indexSelection);
            this.getColumnDescription(this.service, Integer.valueOf(profileProps.getProperty("P_ID_TABLE")));
        }
    }

    public String getUser() {
        return this.login.getText();
    }

    public String getPass() {
        return this.password.getText();
    }

    public String getIdTable() {
        int indexTableSelected = this.listTable.getSelectionIndex();
        return String.valueOf(this.listIDTables.get(indexTableSelected));
    }

    public String getColumnsName() {
        String temp = "";
        for (String name : this.listNameColumns) {
            temp = String.valueOf(temp) + name + ";";
        }
        return temp;
    }

    public String getColumnsType() {
        String temp = "";
        for (String name : this.listTypeColumn) {
            temp = String.valueOf(temp) + name.toLowerCase() + ";";
        }
        return temp;
    }

    public String getColumnsCount() {
        return String.valueOf(this.listNameColumns.size());
    }

    public boolean existSelection() {
        if (this.listTable.getSelectionIndex() == -1) {
            MessageTable.showError(this.getShell(), "Please, select a table to valid your DataSource");
            return false;
        }
        return true;
    }
}

