/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.ui.impl.dataset;

import bpm.google.table.oda.driver.runtime.impl.Connection;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableColumn;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableFilter;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableModel;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableParameter;
import bpm.google.table.oda.driver.ui.Activator;
import bpm.google.table.oda.driver.ui.dialogs.MessageTable;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class GoogleTableFilterPage
extends DataSetWizardPage {
    private ArrayList<OdaGoogleTableFilter> listInputFilters;
    private TableViewer viewer;
    private IStructuredSelection selectionFilter;
    private Table table;
    private OdaGoogleTableModel tableSelected;
    private Button btnAdd;
    private Button btnRemove;
    private Connection connection;
    private static final String MSG_TITLE = "Define Filters: Add a filter, and clik on cells to set them.";

    public GoogleTableFilterPage(String pageName) {
        super(pageName);
        this.setTitle("Filter's Options");
        this.setMessage(MSG_TITLE);
    }

    public GoogleTableFilterPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite arg0) {
        Composite inCompo = new Composite(arg0, 0);
        inCompo.setLayout((Layout)new GridLayout(2, false));
        this.setControl(this.createPageControl(inCompo));
    }

    private Control createPageControl(Composite parent) {
        this.listInputFilters = new ArrayList();
        PGroup groupTable = new PGroup(parent, 65536);
        groupTable.setText("Filters List");
        groupTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        groupTable.setLayout((Layout)new GridLayout(2, false));
        groupTable.setImage(Activator.getDefault().getImageRegistry().get("application_view_list.png"));
        this.viewer = new TableViewer((Composite)groupTable, 68352);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Expression");
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewer, 1));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Operator");
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewer, 2));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Value1");
        column.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.viewer, 1));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Value2");
        column.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.viewer, 2));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Logical.");
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewer, 3));
        this.viewer.setLabelProvider((IBaseLabelProvider)new MyTableLabelProvider());
        this.viewer.setInput(this.listInputFilters);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleTableFilterPage.this.selectionFilter = (IStructuredSelection)event.getSelection();
            }
        });
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        int i = 0;
        int n = this.table.getColumnCount();
        while (i < n) {
            this.table.getColumn(i).setWidth(95);
            ++i;
        }
        this.viewer.refresh();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Composite compoBtn = new Composite((Composite)groupTable, 0);
        compoBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compoBtn.setLayout((Layout)new GridLayout(1, false));
        this.btnAdd = new Button(compoBtn, 0);
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("add.png"));
        this.btnAdd.setText("Add");
        this.btnRemove = new Button(compoBtn, 0);
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("delete.png"));
        this.btnRemove.setText("Remove");
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleTableFilterPage.this.listInputFilters.add(new OdaGoogleTableFilter());
                GoogleTableFilterPage.this.viewer.refresh();
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (GoogleTableFilterPage.this.selectionFilter == null) {
                    MessageDialog.openInformation((Shell)GoogleTableFilterPage.this.getShell(), (String)"Oda Google driver Informations", (String)"Please, select Filter(s) to remove.");
                } else {
                    Object[] objectArray = GoogleTableFilterPage.this.selectionFilter.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        GoogleTableFilterPage.this.listInputFilters.remove((OdaGoogleTableFilter)obj);
                        ++n2;
                    }
                    GoogleTableFilterPage.this.viewer.refresh();
                }
            }
        });
        DataSetDesign dataSetDesigned = this.getInitializationDesign();
        this.initViewerWithDataset(dataSetDesigned);
        return parent;
    }

    private void initViewerWithDataset(DataSetDesign design) {
        String[] tabElementsQuery;
        DataSetDesign dataSetDesigned;
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            this.connection = new Connection();
            this.connection.open(connProps);
            this.tableSelected = this.connection.getTableSelected();
        }
        catch (OdaException e) {
            MessageTable.showError(this.getShell(), "Unable to connect to this g-mail account. Please verify your login/password \n or if you are correctly connected to Internet.");
            e.printStackTrace();
        }
        if (this.tableSelected != null && (dataSetDesigned = this.getInitializationDesign()) != null && dataSetDesigned.getQueryText() != null && !dataSetDesigned.getQueryText().trim().equals("") && !(tabElementsQuery = design.getQueryText().split("\u00f8"))[3].equals("++No filter++")) {
            String[] filters;
            this.listInputFilters.clear();
            String[] stringArray = filters = tabElementsQuery[3].split(";");
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                String[] filterDetail = filter.split("!");
                if (filterDetail.length == 3) {
                    this.listInputFilters.add(new OdaGoogleTableFilter(filterDetail[0], filterDetail[1], "", "", filterDetail[2]));
                } else if (filterDetail.length == 4) {
                    this.listInputFilters.add(new OdaGoogleTableFilter(filterDetail[0], filterDetail[1], filterDetail[2], "", filterDetail[3]));
                } else {
                    this.listInputFilters.add(new OdaGoogleTableFilter(filterDetail[0], filterDetail[1], filterDetail[2], filterDetail[3], filterDetail[4]));
                }
                this.viewer.refresh();
                ++n2;
            }
        }
    }

    protected String[] getTabColumnSelected() {
        String[] tabColSel;
        DataSetDesign dataSetDesigned = this.getInitializationDesign();
        if (dataSetDesigned == null || dataSetDesigned.getQueryText() == null || dataSetDesigned.getQueryText().trim().equals("")) {
            tabColSel = new String[this.tableSelected.getTableCountCol()];
            int i = 0;
            while (i < this.tableSelected.getTableCountCol()) {
                tabColSel[i] = ((OdaGoogleTableColumn)this.tableSelected.getListColumns().get(i)).getColName();
                ++i;
            }
        } else {
            String query = dataSetDesigned.getQueryText();
            String[] strElementsQuery = query.split("\u00f8");
            String strNamesCols = strElementsQuery[0];
            tabColSel = strNamesCols.split(";");
        }
        return tabColSel;
    }

    public boolean checkOperatorToEnableValue(OdaGoogleTableFilter current, int type) {
        String[] tab = OdaGoogleTableParameter.OPERATORS_TAB;
        if (current.getTypeFilter().equals(tab[6])) {
            return true;
        }
        if (current.getTypeFilter().equals(tab[7])) {
            return true;
        }
        if (current.getTypeFilter().equals(tab[0])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[11])) {
            return false;
        }
        if (current.getTypeFilter().equals(tab[4])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[5])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[2])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[3])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[1])) {
            return type == 1;
        }
        if (current.getTypeFilter().equals(tab[8])) {
            return false;
        }
        if (current.getTypeFilter().equals(tab[9])) {
            return false;
        }
        if (current.getTypeFilter().equals(tab[10])) {
            return false;
        }
        return false;
    }

    public boolean checkValue(OdaGoogleTableFilter filter, Object value) {
        Class tempClass = null;
        for (OdaGoogleTableColumn col : this.tableSelected.getListColumns()) {
            if (!col.getColName().equals(filter.getNameColFilter())) continue;
            tempClass = col.getColClass();
        }
        try {
            if (tempClass == Integer.class) {
                Integer.valueOf(value.toString());
            } else if (tempClass == Double.class) {
                Double.valueOf(value.toString());
            } else if (tempClass == Boolean.class) {
                Boolean.valueOf(value.toString());
            }
            this.setMessage(MSG_TITLE);
            return true;
        }
        catch (Exception exception) {
            this.setErrorMessage("This Value must be a " + tempClass.getSimpleName());
            return false;
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        String queryText = this.getQueryText(design);
        design.setQueryText(queryText);
        design.setResultSets(null);
        return design;
    }

    private String getQueryText(DataSetDesign dataSetDesign) {
        String query = "";
        if (this.viewer != null) {
            String queryDataset = dataSetDesign.getQueryText();
            String[] tabElementsQuery = queryDataset.split("\u00f8");
            int i = 0;
            while (i <= 2) {
                query = String.valueOf(query) + tabElementsQuery[i] + "\u00f8";
                ++i;
            }
            if (this.listInputFilters.isEmpty()) {
                query = String.valueOf(query) + "++No filter++";
            } else {
                for (OdaGoogleTableFilter currentFilter : this.listInputFilters) {
                    query = String.valueOf(query) + currentFilter.getNameColFilter() + "!";
                    query = String.valueOf(query) + currentFilter.getTypeFilter() + "!";
                    if (currentFilter.getValue1Filter().length() != 0) {
                        query = String.valueOf(query) + currentFilter.getValue1Filter() + "!";
                    }
                    if (currentFilter.getValue2Filter().length() != 0) {
                        query = String.valueOf(query) + currentFilter.getValue2Filter() + "!";
                    }
                    query = currentFilter.getLogicalSeparator().length() != 0 ? String.valueOf(query) + currentFilter.getLogicalSeparator() + "!" : String.valueOf(query) + "++No Logical++!";
                    query = String.valueOf(query) + ";";
                }
            }
            query = String.valueOf(query) + "\u00f8";
        } else {
            query = dataSetDesign.getQueryText();
        }
        return query;
    }

    protected class ComboEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;
        private String[] tabParamOperators;
        private String[] tabParamLogicals;
        private int typeCombo;

        public ComboEditingSupport(TableViewer viewer, int type) {
            super((ColumnViewer)viewer);
            this.myViewer = viewer;
            this.typeCombo = type;
            this.tabParamOperators = OdaGoogleTableParameter.OPERATORS_TAB;
            this.tabParamLogicals = OdaGoogleTableParameter.LOGICAL_OPERATORS_TAB;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            this.editor = this.typeCombo == 1 ? new ComboBoxCellEditor((Composite)this.myViewer.getControl(), GoogleTableFilterPage.this.getTabColumnSelected()) : (this.typeCombo == 2 ? new ComboBoxCellEditor((Composite)this.myViewer.getControl(), this.tabParamOperators) : new ComboBoxCellEditor((Composite)this.myViewer.getControl(), this.tabParamLogicals));
            return this.editor;
        }

        protected Object getValue(Object element) {
            return new Integer(0);
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleTableFilter current = (OdaGoogleTableFilter)element;
            int indexCombo = Integer.valueOf(value.toString());
            if (this.typeCombo == 1) {
                current.setNameColFilter(GoogleTableFilterPage.this.getTabColumnSelected()[indexCombo]);
            } else if (this.typeCombo == 2) {
                current.setTypeFilter(this.tabParamOperators[indexCombo]);
            } else {
                current.setLogicalSeparator(this.tabParamLogicals[indexCombo]);
            }
            this.myViewer.refresh();
        }
    }

    class MyTableLabelProvider
    implements ITableLabelProvider {
        MyTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return Activator.getDefault().getImageRegistry().get("tick.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            OdaGoogleTableFilter currentFilter = (OdaGoogleTableFilter)element;
            switch (columnIndex) {
                case 0: {
                    return currentFilter.getNameColFilter();
                }
                case 1: {
                    return currentFilter.getTypeFilter();
                }
                case 2: {
                    return currentFilter.getValue1Filter();
                }
                case 3: {
                    return currentFilter.getValue2Filter();
                }
                case 4: {
                    return currentFilter.getLogicalSeparator();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class TextEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;
        private int type;

        public TextEditingSupport(ColumnViewer viewer, int pType) {
            super(viewer);
            this.myViewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
            this.type = pType;
        }

        protected boolean canEdit(Object element) {
            OdaGoogleTableFilter current = (OdaGoogleTableFilter)element;
            return GoogleTableFilterPage.this.checkOperatorToEnableValue(current, this.type);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            OdaGoogleTableFilter current = (OdaGoogleTableFilter)element;
            if (this.type == 1) {
                return current.getValue1Filter();
            }
            return current.getValue2Filter();
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleTableFilter current = (OdaGoogleTableFilter)element;
            if (this.type == 1 && GoogleTableFilterPage.this.checkValue(current, value)) {
                current.setValue1Filter((String)value);
            }
            if (this.type == 2 && GoogleTableFilterPage.this.checkValue(current, value)) {
                current.setValue2Filter((String)value);
            }
            this.myViewer.refresh();
        }
    }
}

