/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.table.oda.driver.ui.impl.dataset;

import bpm.google.table.oda.driver.runtime.impl.Connection;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableColumn;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableModel;
import bpm.google.table.oda.driver.runtime.model.OdaGoogleTableParameter;
import bpm.google.table.oda.driver.ui.Activator;
import bpm.google.table.oda.driver.ui.dialogs.MessageTable;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class GoogleTableDatasetPage
extends DataSetWizardPage {
    private Connection connection;
    private OdaGoogleTableModel tableSelected;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private Button btnAddParam;
    private Button btnDelParam;
    private PGroup group;
    private ArrayList<OdaGoogleTableColumn> listMoving;
    private TableViewer viewerColSelected;
    private Table tableColSelected;
    private IStructuredSelection selectionTableViewer;
    private ArrayList<OdaGoogleTableColumn> listInputTableColumn;
    private static final String CURRENT_DRAG_FROM_TABLE = "Current drag come from the Table of selected Columns";
    private ListViewer viewerListColumn;
    private List myList;
    private IStructuredSelection selectionListViewer;
    private ArrayList<OdaGoogleTableColumn> listInputListColum;
    private static final String CURRENT_DRAG_FROM_LIST = "Current drag come from the List of availables columns";
    private TableViewer viewerParameters;
    private Table tableParameters;
    private IStructuredSelection selectionParameterViewer;
    private ArrayList<OdaGoogleTableParameter> listInputParameter;

    public GoogleTableDatasetPage(String pageName) {
        super(pageName);
        this.setMessage("Select Column(s) to display, and add parameter(s) if needed.");
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initialiseControl();
    }

    private Control createPageControl(Composite pParent) {
        Composite parent = new Composite(pParent, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group = new PGroup(parent, 0);
        this.group.setText("Columns Options");
        this.group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.group.setLayout((Layout)new GridLayout(3, false));
        this.group.setImage(Activator.getDefault().getImageRegistry().get("application_view_list.png"));
        Label lbl = new Label((Composite)this.group, 0);
        lbl.setText("Select Columns to diplay, with control buttons, or using drag and drop.");
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Composite compoGroup = new Composite((Composite)this.group, 2048);
        compoGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        compoGroup.setLayout((Layout)new GridLayout(2, false));
        this.viewerListColumn = new ListViewer(compoGroup, 2826);
        this.myList = this.viewerListColumn.getList();
        this.myList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.createListViewer();
        this.btnAdd = new Button(compoGroup, 8);
        this.btnAdd.setToolTipText("Add a column");
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("add.png"));
        this.btnRemove = new Button(compoGroup, 8);
        this.btnRemove.setToolTipText("Remove a column");
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("delete.png"));
        this.btnAddAll = new Button(compoGroup, 8);
        this.btnAddAll.setToolTipText("Add All columns");
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAddAll.setImage(Activator.getDefault().getImageRegistry().get("table_add.png"));
        this.btnRemoveAll = new Button(compoGroup, 8);
        this.btnRemoveAll.setToolTipText("Remove All columns");
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemoveAll.setImage(Activator.getDefault().getImageRegistry().get("table_delete.png"));
        compoGroup = new Composite((Composite)this.group, 0);
        compoGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        compoGroup.setLayout((Layout)new GridLayout(1, false));
        this.viewerColSelected = new TableViewer(compoGroup, 68354);
        this.tableColSelected = this.viewerColSelected.getTable();
        this.tableColSelected.setLayoutData((Object)new GridData(4, 4, false, true, 1, 5));
        this.createTableViewer();
        lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        PGroup groupeParam = new PGroup(parent, 65536);
        groupeParam.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        groupeParam.setLayout((Layout)new GridLayout(2, false));
        groupeParam.setText("Parameter's Options");
        groupeParam.setImage(Activator.getDefault().getImageRegistry().get("object.png"));
        lbl = new Label((Composite)groupeParam, 0);
        lbl.setText("Use Buttons to add or remove parameter(s). Click on cells to modify them.");
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.viewerParameters = new TableViewer((Composite)groupeParam, 68354);
        this.tableParameters = this.viewerParameters.getTable();
        this.tableParameters.setLayoutData((Object)new GridData(512, 4, true, true, 1, 3));
        this.createParameterViewer();
        Composite compoParam = new Composite((Composite)groupeParam, 0);
        compoParam.setLayoutData((Object)new GridData(512, 4, true, true, 1, 3));
        compoParam.setLayout((Layout)new GridLayout(1, false));
        this.btnAddParam = new Button(compoParam, 8);
        this.btnAddParam.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnAddParam.setText("Add one empty parameter");
        this.btnAddParam.setEnabled(false);
        this.btnDelParam = new Button(compoParam, 8);
        this.btnDelParam.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnDelParam.setText("Remove selected Parameter(s)");
        this.btnDelParam.setEnabled(false);
        lbl = new Label(compoParam, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lbl = new Label(compoParam, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        return parent;
    }

    protected void initialiseControl() {
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            this.connection = new Connection();
            this.connection.open(connProps);
            this.tableSelected = this.connection.getTableSelected();
        }
        catch (OdaException e) {
            MessageTable.showError(this.getShell(), "Unable to connect to this g-mail account. Please verify your login/password \n or if you are correctly connected to Internet.");
            e.printStackTrace();
        }
        if (this.tableSelected != null) {
            this.listInputListColum = new ArrayList();
            this.listInputListColum.addAll(this.tableSelected.getListColumns());
            this.viewerListColumn.setInput(this.listInputListColum);
            this.listInputTableColumn = new ArrayList();
            this.viewerColSelected.setInput(this.listInputTableColumn);
            this.initListenersBtnTool();
            this.listMoving = new ArrayList();
            this.initDragAndDropViewer();
            this.listInputParameter = new ArrayList();
            this.viewerParameters.setInput(this.listInputParameter);
            this.initListenersBtnParameter();
        } else {
            MessageTable.showError(this.getShell(), "Error on the Google fusion table selected.");
        }
        DataSetDesign dataSetDesigned = this.getInitializationDesign();
        if (dataSetDesigned != null && dataSetDesigned.getQueryText() != null && !dataSetDesigned.getQueryText().trim().equals("")) {
            this.initWithDataset(dataSetDesigned);
        }
    }

    private void createListViewer() {
        this.viewerListColumn.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewerListColumn.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof OdaGoogleTableColumn) {
                    return ((OdaGoogleTableColumn)element).getColName();
                }
                return "";
            }
        });
        this.viewerListColumn.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleTableDatasetPage.this.selectionListViewer = (IStructuredSelection)event.getSelection();
            }
        });
    }

    private void createTableViewer() {
        this.viewerColSelected.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's Name");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleTableColumn current = (OdaGoogleTableColumn)element;
                return current.getColName();
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("table_go.png");
            }
        });
        column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's label");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleTableColumn current = (OdaGoogleTableColumn)element;
                if (current.getColLabelName() == null) {
                    current.setColLabelName(current.getColName());
                }
                return current.getColLabelName();
            }
        });
        column.setEditingSupport((EditingSupport)new TableViewerEditingSupport((ColumnViewer)this.viewerColSelected));
        int i = 0;
        int n = this.tableColSelected.getColumnCount();
        while (i < n) {
            this.tableColSelected.getColumn(i).setWidth(145);
            ++i;
        }
        this.tableColSelected.setHeaderVisible(true);
        this.tableColSelected.setLinesVisible(true);
        this.viewerColSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleTableDatasetPage.this.selectionTableViewer = (IStructuredSelection)event.getSelection();
            }
        });
    }

    private void createParameterViewer() {
        this.viewerParameters.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewerParameters, 0);
        column.getColumn().setText("Column's Name");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleTableParameter current = (OdaGoogleTableParameter)element;
                return current.getParamColumn();
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("tick.png");
            }
        });
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewerParameters, 1));
        column = new TableViewerColumn(this.viewerParameters, 0);
        column.getColumn().setText("Operator");
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewerParameters, 2));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleTableParameter current = (OdaGoogleTableParameter)element;
                return current.getParamOperator();
            }
        });
        int i = 0;
        int n = this.tableParameters.getColumnCount();
        while (i < n) {
            this.tableParameters.getColumn(i).setWidth(150);
            ++i;
        }
        this.tableParameters.setHeaderVisible(true);
        this.tableParameters.setLinesVisible(true);
        this.viewerParameters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleTableDatasetPage.this.selectionParameterViewer = (IStructuredSelection)event.getSelection();
            }
        });
    }

    private void initDragAndDropViewer() {
        int operations = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.viewerListColumn.addDragSupport(operations, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (GoogleTableDatasetPage.this.selectionListViewer.isEmpty()) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                GoogleTableDatasetPage.this.listMoving.clear();
                Object[] objectArray = GoogleTableDatasetPage.this.selectionListViewer.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object objSel = objectArray[n2];
                    GoogleTableDatasetPage.this.listMoving.add((OdaGoogleTableColumn)objSel);
                    ++n2;
                }
                event.data = GoogleTableDatasetPage.CURRENT_DRAG_FROM_LIST;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.viewerColSelected.addDropSupport(operations, transfers, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.data.equals(GoogleTableDatasetPage.CURRENT_DRAG_FROM_LIST)) {
                    for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.listMoving) {
                        GoogleTableDatasetPage.this.listInputTableColumn.add(col);
                    }
                    GoogleTableDatasetPage.this.listInputListColum.removeAll(GoogleTableDatasetPage.this.listMoving);
                    GoogleTableDatasetPage.this.viewerColSelected.refresh();
                    GoogleTableDatasetPage.this.viewerListColumn.refresh();
                    GoogleTableDatasetPage.this.checkCanFinish();
                    GoogleTableDatasetPage.this.changeEnableButtonParam();
                }
            }

            public void dropAccept(DropTargetEvent event) {
                event.detail = 1;
            }
        });
        int operations2 = 3;
        Transfer[] transfers2 = new Transfer[]{TextTransfer.getInstance()};
        this.viewerColSelected.addDragSupport(operations2, transfers2, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (GoogleTableDatasetPage.this.selectionTableViewer != null && GoogleTableDatasetPage.this.selectionTableViewer.isEmpty()) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                GoogleTableDatasetPage.this.listMoving.clear();
                Object[] objectArray = GoogleTableDatasetPage.this.selectionTableViewer.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object objSel = objectArray[n2];
                    GoogleTableDatasetPage.this.listMoving.add((OdaGoogleTableColumn)objSel);
                    ++n2;
                }
                event.data = GoogleTableDatasetPage.CURRENT_DRAG_FROM_TABLE;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.viewerListColumn.addDropSupport(operations, transfers, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.data.equals(GoogleTableDatasetPage.CURRENT_DRAG_FROM_TABLE)) {
                    for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.listMoving) {
                        GoogleTableDatasetPage.this.listInputListColum.add(col);
                    }
                    GoogleTableDatasetPage.this.listInputTableColumn.removeAll(GoogleTableDatasetPage.this.listMoving);
                    GoogleTableDatasetPage.this.viewerColSelected.refresh();
                    GoogleTableDatasetPage.this.viewerListColumn.refresh();
                    GoogleTableDatasetPage.this.checkCanFinish();
                    GoogleTableDatasetPage.this.changeEnableButtonParam();
                }
            }

            public void dropAccept(DropTargetEvent event) {
                event.detail = 1;
            }
        });
    }

    protected String[] getTabColumnSelected() {
        String[] tabColSel = new String[this.listInputTableColumn.size()];
        int i = 0;
        while (i < this.listInputTableColumn.size()) {
            tabColSel[i] = this.listInputTableColumn.get(i).getColName();
            ++i;
        }
        return tabColSel;
    }

    protected void initListenersBtnTool() {
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String s = "";
                for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.listInputTableColumn) {
                    s = String.valueOf(s) + col.getColName() + " " + col.getColLabelName() + " " + col.getColClass().getSimpleName();
                    s = String.valueOf(s) + "\n";
                }
                GoogleTableDatasetPage.this.setPageComplete(true);
                Object[] objectArray = GoogleTableDatasetPage.this.selectionListViewer.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object colSelect = objectArray[n2];
                    GoogleTableDatasetPage.this.listInputTableColumn.add((OdaGoogleTableColumn)colSelect);
                    GoogleTableDatasetPage.this.listInputListColum.remove((OdaGoogleTableColumn)colSelect);
                    ++n2;
                }
                GoogleTableDatasetPage.this.viewerColSelected.refresh();
                GoogleTableDatasetPage.this.viewerListColumn.refresh();
                GoogleTableDatasetPage.this.changeEnableButtonParam();
            }
        });
        this.btnAddAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleTableDatasetPage.this.setPageComplete(true);
                for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.listInputListColum) {
                    GoogleTableDatasetPage.this.listInputTableColumn.add(col);
                }
                GoogleTableDatasetPage.this.listInputListColum.clear();
                GoogleTableDatasetPage.this.viewerListColumn.refresh();
                GoogleTableDatasetPage.this.viewerColSelected.refresh();
                GoogleTableDatasetPage.this.changeEnableButtonParam();
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList<OdaGoogleTableColumn> listColToRemove = new ArrayList<OdaGoogleTableColumn>();
                Object[] objectArray = GoogleTableDatasetPage.this.selectionTableViewer.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    listColToRemove.add((OdaGoogleTableColumn)obj);
                    ++n2;
                }
                GoogleTableDatasetPage.this.listInputTableColumn.removeAll(listColToRemove);
                GoogleTableDatasetPage.this.listInputListColum.addAll(listColToRemove);
                GoogleTableDatasetPage.this.viewerColSelected.refresh();
                GoogleTableDatasetPage.this.viewerListColumn.refresh();
                GoogleTableDatasetPage.this.changeEnableButtonParam();
            }
        });
        this.btnRemoveAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleTableDatasetPage.this.setPageComplete(false);
                for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.listInputTableColumn) {
                    GoogleTableDatasetPage.this.listInputListColum.add(col);
                }
                GoogleTableDatasetPage.this.listInputTableColumn.clear();
                GoogleTableDatasetPage.this.viewerListColumn.refresh();
                GoogleTableDatasetPage.this.viewerColSelected.refresh();
                GoogleTableDatasetPage.this.changeEnableButtonParam();
            }
        });
    }

    protected void initListenersBtnParameter() {
        this.btnAddParam.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleTableDatasetPage.this.listInputParameter.add(new OdaGoogleTableParameter());
                GoogleTableDatasetPage.this.viewerParameters.refresh();
                GoogleTableDatasetPage.this.changeEnableButtonParam();
            }
        });
        this.btnDelParam.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (GoogleTableDatasetPage.this.selectionParameterViewer == null) {
                    MessageDialog.openInformation((Shell)GoogleTableDatasetPage.this.getShell(), (String)"Oda Google driver Informations", (String)"Please, select Parameter(s) to remove.");
                } else {
                    Object[] objectArray = GoogleTableDatasetPage.this.selectionParameterViewer.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        GoogleTableDatasetPage.this.listInputParameter.remove((OdaGoogleTableParameter)obj);
                        ++n2;
                    }
                    GoogleTableDatasetPage.this.changeEnableButtonParam();
                    GoogleTableDatasetPage.this.viewerParameters.refresh();
                }
            }
        });
    }

    protected void changeEnableButtonParam() {
        if (this.listInputTableColumn.size() == 0) {
            this.btnAddParam.setEnabled(false);
            this.btnDelParam.setEnabled(false);
        } else {
            this.btnAddParam.setEnabled(true);
            this.btnDelParam.setEnabled(true);
        }
    }

    protected void checkCanFinish() {
        if (this.listInputTableColumn.size() > 0) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void initWithDataset(DataSetDesign dataSetDesigned) {
        String[] tabElementsQuery = dataSetDesigned.getQueryText().split("\u00f8");
        String strColSelect = tabElementsQuery[0];
        String[] listColsSelected = strColSelect.split(";");
        this.listInputTableColumn.clear();
        this.listInputListColum.clear();
        String[] stringArray = listColsSelected;
        int n = listColsSelected.length;
        int n2 = 0;
        while (n2 < n) {
            String nameColSelected = stringArray[n2];
            for (Object col : this.tableSelected.getListColumns()) {
                if (!nameColSelected.equals(col.getColName())) continue;
                this.listInputTableColumn.add((OdaGoogleTableColumn)col);
            }
            ++n2;
        }
        this.viewerColSelected.refresh();
        for (OdaGoogleTableColumn col : this.tableSelected.getListColumns()) {
            if (this.listInputTableColumn.contains(col)) continue;
            this.listInputListColum.add(col);
        }
        this.viewerListColumn.refresh();
        String queryColSelectedLabel = tabElementsQuery[1];
        String[] listColsSelectedLabels = queryColSelectedLabel.split(";");
        int indexLabel = 0;
        for (OdaGoogleTableColumn currentCol : this.listInputTableColumn) {
            currentCol.setColLabelName(listColsSelectedLabels[indexLabel]);
            ++indexLabel;
        }
        this.viewerColSelected.refresh();
        String queryParameters = tabElementsQuery[2];
        if (!queryParameters.equals("++No Parameter++")) {
            String[] listParameters;
            String[] stringArray2 = listParameters = queryParameters.split(";");
            int n3 = listParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                String currentDetailsParam = stringArray2[n4];
                String[] detailsParam = currentDetailsParam.split("!");
                String colParameter = detailsParam[0];
                String opeParameter = detailsParam[1];
                this.listInputParameter.add(new OdaGoogleTableParameter(colParameter, opeParameter));
                ++n4;
            }
        }
        this.changeEnableButtonParam();
        this.viewerParameters.refresh();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        String queryText = this.getQueryText(design);
        design.setQueryText(queryText);
        if (this.connection == null) {
            design.setParameters(null);
        } else {
            DataSetParameters dataSetParameter = null;
            try {
                IQuery query = this.connection.newQuery(null);
                query.prepare(queryText);
                IParameterMetaData pMd = query.getParameterMetaData();
                dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)pMd, (ParameterMode)ParameterMode.IN_LITERAL);
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            design.setParameters(dataSetParameter);
        }
        design.setResultSets(null);
        return design;
    }

    private String getQueryText(DataSetDesign design) {
        String query = "";
        if (this.listInputListColum != null) {
            for (OdaGoogleTableColumn col : this.listInputTableColumn) {
                query = String.valueOf(query) + col.getColName() + ";";
            }
            query = String.valueOf(query) + "\u00f8";
            for (OdaGoogleTableColumn col : this.listInputTableColumn) {
                query = String.valueOf(query) + col.getColLabelName() + ";";
            }
            query = String.valueOf(query) + "\u00f8";
            if (this.listInputParameter.size() == 0) {
                query = String.valueOf(query) + "++No Parameter++\u00f8";
            } else {
                for (OdaGoogleTableParameter currentParam : this.listInputParameter) {
                    query = String.valueOf(query) + currentParam.getParamColumn() + "!";
                    query = String.valueOf(query) + currentParam.getParamOperator() + "!";
                    query = String.valueOf(query) + ";";
                }
                query = String.valueOf(query) + "\u00f8";
            }
            if (design == null || design.getQueryText() == null || design.getQueryText().trim().equals("")) {
                query = String.valueOf(query) + "++No filter++\u00f8";
            } else {
                String dataSetQuery = design.getQueryText();
                String[] tabQueryColAndFilter = dataSetQuery.split("\u00f8");
                String strQueryFilter = tabQueryColAndFilter[3];
                query = String.valueOf(query) + strQueryFilter + "\u00f8";
            }
        } else {
            query = design.getQueryText();
        }
        return query;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    protected class ComboEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;
        private String[] tabParamOperators;
        private int typeCombo;

        public ComboEditingSupport(TableViewer viewer, int type) {
            super((ColumnViewer)viewer);
            this.myViewer = viewer;
            this.typeCombo = type;
            this.tabParamOperators = OdaGoogleTableParameter.OPERATORS_TAB;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            this.editor = this.typeCombo == 1 ? new ComboBoxCellEditor((Composite)this.myViewer.getControl(), GoogleTableDatasetPage.this.getTabColumnSelected()) : new ComboBoxCellEditor((Composite)this.myViewer.getControl(), this.tabParamOperators);
            return this.editor;
        }

        protected Object getValue(Object element) {
            return new Integer(0);
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleTableParameter current = (OdaGoogleTableParameter)element;
            int indexCombo = Integer.valueOf(value.toString());
            if (this.typeCombo == 1) {
                current.setParamColumn(GoogleTableDatasetPage.this.getTabColumnSelected()[indexCombo]);
            } else {
                current.setParamOperator(this.tabParamOperators[indexCombo]);
            }
            this.myViewer.refresh();
        }
    }

    protected class TableViewerEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;

        public TableViewerEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.myViewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            OdaGoogleTableColumn current = (OdaGoogleTableColumn)element;
            return current.getColLabelName();
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleTableColumn current = (OdaGoogleTableColumn)element;
            current.setColLabelName((String)value);
            for (OdaGoogleTableColumn col : GoogleTableDatasetPage.this.tableSelected.getListColumns()) {
                if (!col.equals(current.getColName())) continue;
                col.setColLabelName((String)value);
            }
            this.myViewer.refresh();
        }
    }
}

