/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingleThreadExecutor
implements Executor {
    private static final Runnable POISON = () -> {};
    private static final Runnable PARK = () -> {};
    private static final Logger logger = Logger.getLogger(SingleThreadExecutor.class.getName());
    private final StampedLock stampedLock = new StampedLock();
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final Thread workerThread;

    SingleThreadExecutor(ThreadFactory factory) {
        this.workerThread = factory.newThread(this::doLifeCycle);
        this.workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp == 0L) {
            task.run();
            return;
        }
        try {
            this.taskQueue.add(task);
            LockSupport.unpark(this.workerThread);
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    public void stopExecutionThread() {
        if (this.stampedLock.isWriteLocked()) {
            return;
        }
        this.stampedLock.writeLock();
        this.taskQueue.add(POISON);
        LockSupport.unpark(this.workerThread);
    }

    private void doLifeCycle() {
        while (true) {
            Thread.interrupted();
            Runnable task = this.taskQueue.poll();
            if (task == POISON) {
                return;
            }
            if (task == PARK && (task = this.taskQueue.poll()) == null) {
                LockSupport.park(this);
                continue;
            }
            if (task != null) {
                SingleThreadExecutor.executeAndLogErrors(task);
                continue;
            }
            this.taskQueue.add(PARK);
        }
    }

    private static void executeAndLogErrors(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e, () -> "Fail to execute " + task + " in async mode because of " + e.getMessage());
        }
    }
}

