/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final AtomicInteger createdThreads = new AtomicInteger(0);
    private final String threadNameFormat;

    public DaemonThreadFactory(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        int threadNumber = this.createdThreads.incrementAndGet();
        String threadName = String.format(this.threadNameFormat, threadNumber);
        Thread thread = new Thread(runnable);
        thread.setName(threadName);
        thread.setDaemon(true);
        return thread;
    }

    public String toString() {
        return "DaemonThreadFactory{createdThreads=" + this.createdThreads + ", threadNameFormat='" + this.threadNameFormat + '\'' + '}';
    }

    public int getCreatedThreads() {
        return this.createdThreads.get();
    }
}

