/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top.impl.recorder;

import com.github.rollingmetrics.top.impl.recorder.PositionRecorder;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.HdrHistogram.WriterReaderPhaser;

public class TwoPhasePositionRecorder {
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile PositionRecorder active;
    private PositionRecorder inactive;

    public TwoPhasePositionRecorder(int size, long latencyThresholdNanos, int maxDescriptionLength) {
        this.active = PositionRecorder.createRecorder(size, latencyThresholdNanos, maxDescriptionLength);
        this.inactive = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.active.update(timestamp, latencyTime, latencyUnit, descriptionSupplier);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized PositionRecorder getIntervalRecorder() {
        return this.getIntervalRecorder(null);
    }

    public synchronized PositionRecorder getIntervalRecorder(PositionRecorder recorderToRecycle) {
        this.inactive = recorderToRecycle;
        this.performIntervalSample();
        PositionRecorder sampledQueryTop = this.inactive;
        this.inactive = null;
        return sampledQueryTop;
    }

    private void performIntervalSample() {
        try {
            this.recordingPhaser.readerLock();
            if (this.inactive == null) {
                this.inactive = this.active.createEmptyCopy();
            } else {
                this.inactive.reset();
            }
            PositionRecorder temp = this.inactive;
            this.inactive = this.active;
            this.active = temp;
            this.recordingPhaser.flipPhase();
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }
}

