/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top.impl.recorder;

import com.github.rollingmetrics.top.Position;
import com.github.rollingmetrics.top.impl.collector.PositionCollector;
import com.github.rollingmetrics.top.impl.recorder.PositionRecorder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class MultiPositionRecorder
extends PositionRecorder {
    private final ConcurrentSkipListMap<PositionKey, Position> positions;
    private final AtomicLong phaseSequence = new AtomicLong();

    MultiPositionRecorder(int size, long latencyThresholdNanos, int maxDescriptionLength) {
        super(size, latencyThresholdNanos, maxDescriptionLength);
        this.positions = new ConcurrentSkipListMap();
        long phase = this.phaseSequence.get();
        for (int i = 1; i <= size; ++i) {
            Position fake = new Position(0L, -i, TimeUnit.NANOSECONDS, "");
            this.positions.put(new PositionKey(phase, fake), fake);
        }
    }

    @Override
    protected void updateConcurrently(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier, long latencyNanos) {
        long currentPhase;
        Map.Entry<PositionKey, Position> firstEntry = this.positions.firstEntry();
        PositionKey firstKey = firstEntry.getKey();
        Position firstPosition = firstEntry.getValue();
        if (!this.isNeedToAdd(timestamp, latencyNanos, firstPosition, firstKey, currentPhase = this.phaseSequence.get())) {
            return;
        }
        Position position = new Position(timestamp, latencyTime, latencyUnit, descriptionSupplier, this.maxDescriptionLength);
        if (this.positions.putIfAbsent(new PositionKey(currentPhase, position), position) == null) {
            this.positions.pollFirstEntry();
        }
    }

    @Override
    public List<Position> getPositionsInDescendingOrder() {
        ArrayList<Position> descendingTop = null;
        long currentPhase = this.phaseSequence.get();
        for (Map.Entry entry : this.positions.descendingMap().entrySet()) {
            Position position = (Position)entry.getValue();
            if (currentPhase != ((PositionKey)entry.getKey()).phase) {
                return this.notNullList(descendingTop);
            }
            if (this.isFake(position)) {
                return this.notNullList(descendingTop);
            }
            if (descendingTop == null) {
                descendingTop = new ArrayList<Position>(this.size);
            }
            descendingTop.add(position);
        }
        return this.notNullList(descendingTop);
    }

    @Override
    public void reset() {
        this.phaseSequence.incrementAndGet();
    }

    @Override
    public void addInto(PositionCollector collector) {
        long currentPhase = this.phaseSequence.get();
        for (Map.Entry positionEntry : this.positions.descendingMap().entrySet()) {
            PositionKey key = (PositionKey)positionEntry.getKey();
            if (key.phase != currentPhase) {
                return;
            }
            Position position = (Position)positionEntry.getValue();
            if (this.isFake(position)) {
                return;
            }
            if (collector.add(position)) continue;
            return;
        }
    }

    private boolean isNeedToAdd(long newTimestamp, long newLatencyNanos, Position firstPosition, PositionKey firstKey, long currentPhase) {
        if (firstKey.phase != currentPhase) {
            return true;
        }
        return super.isNeedToAdd(newTimestamp, newLatencyNanos, firstPosition);
    }

    private boolean isFake(Position position) {
        return position.getLatencyInNanoseconds() < 0L;
    }

    private List<Position> notNullList(List<Position> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public String toString() {
        return "MultiPositionRecorder{positions=" + this.positions + ", phaseSequence=" + this.phaseSequence + '}';
    }

    private final class PositionKey
    implements Comparable<PositionKey> {
        final long phase;
        final Position position;

        public PositionKey(long phase, Position position) {
            this.phase = phase;
            this.position = position;
        }

        @Override
        public int compareTo(PositionKey other) {
            if (this.phase != other.phase) {
                if (this.phase - other.phase > 0L) {
                    return 1;
                }
                return -1;
            }
            return this.position.compareTo(other.position);
        }
    }
}

