/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top.impl.collector;

import com.github.rollingmetrics.top.Position;
import com.github.rollingmetrics.top.impl.collector.PositionCollector;
import java.util.Collections;
import java.util.List;

class SinglePositionCollector
implements PositionCollector {
    private Position max;

    SinglePositionCollector() {
    }

    @Override
    public boolean add(Position position) {
        if (PositionCollector.isNeedToAdd(position, this.max)) {
            this.max = position;
            return true;
        }
        return false;
    }

    @Override
    public List<Position> getPositionsInDescendingOrder() {
        if (this.max == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.max);
    }

    @Override
    public void reset() {
        this.max = null;
    }

    @Override
    public void addInto(PositionCollector other) {
        if (this.max != null) {
            other.add(this.max);
        }
    }

    public String toString() {
        return "SinglePositionCollector{max=" + this.max + '}';
    }
}

