/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top.impl.collector;

import com.github.rollingmetrics.top.Position;
import com.github.rollingmetrics.top.impl.collector.MultiPositionCollector;
import com.github.rollingmetrics.top.impl.collector.SinglePositionCollector;
import java.util.List;

public interface PositionCollector {
    public boolean add(Position var1);

    public void addInto(PositionCollector var1);

    public void reset();

    public List<Position> getPositionsInDescendingOrder();

    public static PositionCollector createCollector(int size) {
        if (size == 1) {
            return new SinglePositionCollector();
        }
        return new MultiPositionCollector(size);
    }

    public static boolean isNeedToAdd(Position newPosition, Position currentMinimum) {
        if (currentMinimum == null) {
            return true;
        }
        if (newPosition.getLatencyInNanoseconds() > currentMinimum.getLatencyInNanoseconds()) {
            return true;
        }
        if (newPosition.getLatencyInNanoseconds() == currentMinimum.getLatencyInNanoseconds()) {
            return newPosition.getTimestamp() > currentMinimum.getTimestamp();
        }
        return false;
    }
}

