/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.histogram.accumulator;

import cdjd.com.codahale.metrics.Snapshot;
import com.github.rollingmetrics.histogram.accumulator.Accumulator;
import com.github.rollingmetrics.histogram.util.HistogramUtil;
import com.github.rollingmetrics.histogram.util.Printer;
import java.util.function.Function;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

public class UniformAccumulator
implements Accumulator {
    private final Recorder recorder;
    private final Histogram uniformHistogram;
    private Histogram intervalHistogram;

    public UniformAccumulator(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
        this.uniformHistogram = HistogramUtil.createNonConcurrentCopy(this.intervalHistogram);
    }

    @Override
    public void recordSingleValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) {
        this.recorder.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    @Override
    public final synchronized Snapshot getSnapshot(Function<Histogram, Snapshot> snapshotTaker) {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        HistogramUtil.addSecondToFirst(this.uniformHistogram, this.intervalHistogram);
        return HistogramUtil.getSnapshot(this.uniformHistogram, snapshotTaker);
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return this.intervalHistogram.getEstimatedFootprintInBytes() * 3;
    }

    public String toString() {
        return "UniformAccumulator{\nuniformHistogram=" + Printer.histogramToString(this.uniformHistogram) + "\n, intervalHistogram=" + Printer.histogramToString(this.intervalHistogram) + '}';
    }
}

