/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.histogram;

import cdjd.com.codahale.metrics.Reservoir;
import cdjd.com.codahale.metrics.Snapshot;
import com.github.rollingmetrics.histogram.OverflowResolver;
import com.github.rollingmetrics.histogram.accumulator.Accumulator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

class HdrReservoir
implements Reservoir {
    private final Accumulator accumulator;
    private final Function<Histogram, Snapshot> snapshotTaker;
    private final long highestTrackableValue;
    private final OverflowResolver overflowResolver;
    private final long expectedIntervalBetweenValueSamples;

    HdrReservoir(Accumulator accumulator, Optional<double[]> predefinedPercentiles, Optional<Long> highestTrackableValue, Optional<OverflowResolver> overflowResolver, Optional<Long> expectedIntervalBetweenValueSamples) {
        this.accumulator = accumulator;
        this.highestTrackableValue = highestTrackableValue.orElse(Long.MAX_VALUE);
        this.overflowResolver = overflowResolver.orElse(null);
        this.expectedIntervalBetweenValueSamples = expectedIntervalBetweenValueSamples.orElse(0L);
        if (predefinedPercentiles.isPresent()) {
            double[] percentiles = predefinedPercentiles.get();
            this.snapshotTaker = histogram -> HdrReservoir.takeSmartSnapshot(percentiles, histogram);
        } else {
            this.snapshotTaker = HdrReservoir::takeFullSnapshot;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You should not use this method https://github.com/dropwizard/metrics/issues/874");
    }

    @Override
    public void update(long value) {
        if (value > this.highestTrackableValue) {
            switch (this.overflowResolver) {
                case SKIP: {
                    return;
                }
                case PASS_THRU: {
                    break;
                }
                case REDUCE_TO_HIGHEST_TRACKABLE: {
                    value = this.highestTrackableValue;
                }
            }
        }
        this.accumulator.recordSingleValueWithExpectedInterval(value, this.expectedIntervalBetweenValueSamples);
    }

    @Override
    public Snapshot getSnapshot() {
        return this.accumulator.getSnapshot(this.snapshotTaker);
    }

    public int getEstimatedFootprintInBytes() {
        return this.accumulator.getEstimatedFootprintInBytes();
    }

    static Snapshot takeSmartSnapshot(double[] predefinedQuantiles, Histogram histogram) {
        long max = histogram.getMaxValue();
        long min2 = histogram.getMinValue();
        double mean = histogram.getMean();
        double median = histogram.getValueAtPercentile(50.0);
        double stdDeviation = histogram.getStdDeviation();
        double[] values = new double[predefinedQuantiles.length];
        for (int i = 0; i < predefinedQuantiles.length; ++i) {
            double quantile = predefinedQuantiles[i];
            double percentile = quantile * 100.0;
            values[i] = histogram.getValueAtPercentile(percentile);
        }
        return HdrReservoir.createSmartSnapshot(predefinedQuantiles, max, min2, mean, median, stdDeviation, values);
    }

    static Snapshot createSmartSnapshot(final double[] predefinedQuantiles, final long max, final long min2, final double mean, final double median, final double stdDeviation, final double[] values) {
        return new Snapshot(){

            @Override
            public double getValue(double quantile) {
                for (int i = 0; i < predefinedQuantiles.length; ++i) {
                    if (!(quantile <= predefinedQuantiles[i])) continue;
                    return values[i];
                }
                return max;
            }

            @Override
            public long[] getValues() {
                long[] toReturn = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    toReturn[i] = (long)values[i];
                }
                return toReturn;
            }

            @Override
            public int size() {
                return values.length;
            }

            @Override
            public double getMedian() {
                return median;
            }

            @Override
            public long getMax() {
                return max;
            }

            @Override
            public double getMean() {
                return mean;
            }

            @Override
            public long getMin() {
                return min2;
            }

            @Override
            public double getStdDev() {
                return stdDeviation;
            }

            @Override
            public void dump(OutputStream output) {
                try (PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                    for (double value : values) {
                        p.printf("%f%n", value);
                    }
                }
            }

            public String toString() {
                StringBuilder distribution = new StringBuilder();
                for (int i = 0; i < predefinedQuantiles.length; ++i) {
                    distribution.append(predefinedQuantiles[i] * 100.0).append("%:").append(values[i]).append("; ");
                }
                return "SmartSnapshot{max=" + max + ", min=" + min2 + ", mean=" + mean + ", stdDeviation=" + stdDeviation + ", distribution=" + distribution + '}';
            }
        };
    }

    private static Snapshot takeFullSnapshot(final Histogram histogram) {
        return new Snapshot(){

            @Override
            public double getValue(double quantile) {
                double percentile = quantile * 100.0;
                return histogram.getValueAtPercentile(percentile);
            }

            @Override
            public long[] getValues() {
                long[] values = new long[1024];
                int i = 0;
                for (HistogramIterationValue value : histogram.recordedValues()) {
                    values[i] = value.getValueIteratedTo();
                    if (++i != values.length) continue;
                    values = Arrays.copyOf(values, values.length * 2);
                }
                return Arrays.copyOf(values, i);
            }

            @Override
            public int size() {
                return (int)histogram.getTotalCount();
            }

            @Override
            public long getMax() {
                return histogram.getMaxValue();
            }

            @Override
            public double getMean() {
                return histogram.getMean();
            }

            @Override
            public long getMin() {
                return histogram.getMinValue();
            }

            @Override
            public double getStdDev() {
                return histogram.getStdDeviation();
            }

            @Override
            public void dump(OutputStream output) {
                try (PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                    for (HistogramIterationValue value : histogram.recordedValues()) {
                        int j = 0;
                        while ((long)j < value.getCountAddedInThisIterationStep()) {
                            p.printf("%d%n", value.getValueIteratedTo());
                            ++j;
                        }
                    }
                }
            }

            public String toString() {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(stream, true);
                histogram.outputPercentileDistribution(printStream, Double.valueOf(1.0));
                String distributionAsString = new String(stream.toByteArray());
                return "FullSnapshot{" + distributionAsString + "}";
            }
        };
    }

    public String toString() {
        return "HdrReservoir{highestTrackableValue=" + this.highestTrackableValue + ", overflowResolver=" + (Object)((Object)this.overflowResolver) + ", expectedIntervalBetweenValueSamples=" + this.expectedIntervalBetweenValueSamples + "\n accumulator=" + this.accumulator + '}';
    }
}

