/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.counter;

import com.github.rollingmetrics.counter.WindowCounter;
import com.github.rollingmetrics.histogram.util.Printer;
import com.github.rollingmetrics.util.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public class SmoothlyDecayingRollingCounter
implements WindowCounter {
    static final int MAX_CHUNKS = 1000;
    static final long MIN_CHUNK_RESETTING_INTERVAL_MILLIS = 100L;
    private final long intervalBetweenResettingMillis;
    private final Clock clock;
    private final long creationTimestamp;
    private final Chunk[] chunks;

    public SmoothlyDecayingRollingCounter(Duration rollingWindow, int numberChunks) {
        this(rollingWindow, numberChunks, Clock.defaultClock());
    }

    public Duration getRollingWindow() {
        return Duration.ofMillis((long)(this.chunks.length - 1) * this.intervalBetweenResettingMillis);
    }

    public int getChunkCount() {
        return this.chunks.length - 1;
    }

    public SmoothlyDecayingRollingCounter(Duration rollingWindow, int numberChunks, Clock clock) {
        if (numberChunks < 2) {
            throw new IllegalArgumentException("numberChunks should be >= 2");
        }
        if (numberChunks > 1000) {
            throw new IllegalArgumentException("number of chunks should be <=1000");
        }
        long rollingWindowMillis = rollingWindow.toMillis();
        this.intervalBetweenResettingMillis = rollingWindowMillis / (long)numberChunks;
        if (this.intervalBetweenResettingMillis < 100L) {
            throw new IllegalArgumentException("intervalBetweenResettingMillis should be >=100");
        }
        this.clock = clock;
        this.creationTimestamp = clock.currentTimeMillis();
        this.chunks = new Chunk[numberChunks + 1];
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = new Chunk(i);
        }
    }

    @Override
    public void add(long delta) {
        long nowMillis = this.clock.currentTimeMillis();
        long millisSinceCreation = nowMillis - this.creationTimestamp;
        long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
        int chunkIndex = (int)intervalsSinceCreation % this.chunks.length;
        this.chunks[chunkIndex].add(delta, nowMillis);
    }

    @Override
    public long getSum() {
        long currentTimeMillis = this.clock.currentTimeMillis();
        long millisSinceCreation = currentTimeMillis - this.creationTimestamp;
        long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
        int newestChunkIndex = (int)intervalsSinceCreation % this.chunks.length;
        long sum = 0L;
        int i = newestChunkIndex + 1;
        for (int iteration = 0; iteration < this.chunks.length; ++iteration) {
            if (i == this.chunks.length) {
                i = 0;
            }
            Chunk chunk = this.chunks[i];
            sum += chunk.getSum(currentTimeMillis);
            ++i;
        }
        return sum;
    }

    public String toString() {
        return "SmoothlyDecayingRollingCounter{, intervalBetweenResettingMillis=" + this.intervalBetweenResettingMillis + ", clock=" + this.clock + ", creationTimestamp=" + this.creationTimestamp + ", chunks=" + Printer.printArray(this.chunks, "chunk") + '}';
    }

    private final class Phase {
        final LongAdder adder = new LongAdder();
        volatile long proposedInvalidationTimestamp;

        Phase(long proposedInvalidationTimestamp) {
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        long getSum(long currentTimeMillis) {
            long proposedInvalidationTimestamp = this.proposedInvalidationTimestamp;
            if (currentTimeMillis >= proposedInvalidationTimestamp) {
                return 0L;
            }
            long sum = this.adder.sum();
            long beforeInvalidateMillis = proposedInvalidationTimestamp - currentTimeMillis;
            if (beforeInvalidateMillis < SmoothlyDecayingRollingCounter.this.intervalBetweenResettingMillis) {
                double decayingCoefficient = (double)beforeInvalidateMillis / (double)SmoothlyDecayingRollingCounter.this.intervalBetweenResettingMillis;
                sum = (long)((double)sum * decayingCoefficient);
            }
            return sum;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Phase{");
            sb.append("sum=").append(this.adder);
            sb.append(", proposedInvalidationTimestamp=").append(this.proposedInvalidationTimestamp);
            sb.append('}');
            return sb.toString();
        }
    }

    private final class Chunk {
        final Phase left;
        final Phase right;
        final AtomicReference<Phase> currentPhaseRef;

        Chunk(int chunkIndex) {
            long invalidationTimestamp = SmoothlyDecayingRollingCounter.this.creationTimestamp + (long)(SmoothlyDecayingRollingCounter.this.chunks.length + chunkIndex) * SmoothlyDecayingRollingCounter.this.intervalBetweenResettingMillis;
            this.left = new Phase(invalidationTimestamp);
            this.right = new Phase(Long.MAX_VALUE);
            this.currentPhaseRef = new AtomicReference<Phase>(this.left);
        }

        long getSum(long currentTimeMillis) {
            return this.currentPhaseRef.get().getSum(currentTimeMillis);
        }

        void add(long delta, long currentTimeMillis) {
            Phase currentPhase = this.currentPhaseRef.get();
            long currentPhaseProposedInvalidationTimestamp = currentPhase.proposedInvalidationTimestamp;
            if (currentTimeMillis < currentPhaseProposedInvalidationTimestamp) {
                if (currentPhaseProposedInvalidationTimestamp != Long.MAX_VALUE) {
                    currentPhase.adder.add(delta);
                } else {
                    this.currentPhaseRef.get().adder.add(delta);
                }
            } else {
                Phase expiredPhase = currentPhase;
                Phase nextPhase = expiredPhase == this.left ? this.right : this.left;
                nextPhase.adder.add(delta);
                if (this.currentPhaseRef.compareAndSet(expiredPhase, nextPhase)) {
                    expiredPhase.adder.reset();
                    expiredPhase.proposedInvalidationTimestamp = Long.MAX_VALUE;
                    long millisSinceCreation = currentTimeMillis - SmoothlyDecayingRollingCounter.this.creationTimestamp;
                    long intervalsSinceCreation = millisSinceCreation / SmoothlyDecayingRollingCounter.this.intervalBetweenResettingMillis;
                    nextPhase.proposedInvalidationTimestamp = SmoothlyDecayingRollingCounter.this.creationTimestamp + (intervalsSinceCreation + (long)SmoothlyDecayingRollingCounter.this.chunks.length) * SmoothlyDecayingRollingCounter.this.intervalBetweenResettingMillis;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Chunk{");
            sb.append("currentPhaseRef=").append(this.currentPhaseRef);
            sb.append('}');
            return sb.toString();
        }
    }
}

