/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.proxy;

import com.dremio.jdbc.proxy.InvocationReporter;
import com.dremio.jdbc.proxy.InvocationReporterImpl;
import com.dremio.jdbc.proxy.ProxiesManager;
import com.dremio.jdbc.proxy.ProxySetupSQLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class TracingProxyDriver
implements Driver {
    private static final String JDBC_URL_PREFIX = "jdbc:proxy:";
    private static final InvocationReporter reporter;
    private final ProxiesManager proxiesManager = new ProxiesManager(reporter);
    private Driver proxyDriver;

    private void setProxyDriver(Driver newProxyDriver, Driver proxiedDriver) {
        if (null != this.proxyDriver && newProxyDriver != this.proxyDriver) {
            reporter.setupMessage("Note:  Multiple drivers proxied; Driver-level methods such as getMajorVersion() will be routed to latest (" + proxiedDriver + ").");
        }
        this.proxyDriver = newProxyDriver;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        boolean accepted;
        reporter.setupMessage("Proxy's acceptsURL(...) called with " + (null == url ? "null" : "\"" + url + "\"."));
        if (null == url || !url.startsWith(JDBC_URL_PREFIX)) {
            accepted = false;
        } else {
            UrlHandler urlHandler = new UrlHandler(this.proxiesManager, url);
            this.setProxyDriver(urlHandler.getProxyDriver(), urlHandler.getProxiedDriver());
            accepted = true;
        }
        reporter.setupMessage("Proxy's acceptsURL( " + (null == url ? "null" : "\"" + url + "\"") + " ) returning " + accepted + ".");
        return accepted;
    }

    @Override
    public Connection connect(String url, Properties info) throws ProxySetupSQLException {
        Connection result;
        reporter.setupMessage("Proxy's connect(...) called with URL " + (null == url ? "null" : "\"" + url + "\"") + ".");
        if (null == url || !url.startsWith(JDBC_URL_PREFIX)) {
            result = null;
        } else {
            UrlHandler urlHandler = new UrlHandler(this.proxiesManager, url);
            this.setProxyDriver(urlHandler.getProxyDriver(), urlHandler.getProxiedDriver());
            try {
                result = this.proxyDriver.connect(urlHandler.getProxiedUrl(), info);
            }
            catch (SQLException e) {
                throw new ProxySetupSQLException("Exception from proxied driver: " + e, e);
            }
        }
        return result;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.proxyDriver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.proxyDriver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.proxyDriver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.proxyDriver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.proxyDriver.getParentLogger();
    }

    static {
        TracingProxyDriver proxyDriver;
        InvocationReporterImpl simpleReporter = new InvocationReporterImpl();
        simpleReporter.setupMessage("Proxy driver " + TracingProxyDriver.class + " initializing.");
        simpleReporter.reportAbbreviatedPackages();
        reporter = simpleReporter;
        reporter.setupMessage("Proxy driver registering with DriverManager.");
        try {
            proxyDriver = new TracingProxyDriver();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in initializing " + TracingProxyDriver.class + ": " + e, e);
        }
        try {
            DriverManager.registerDriver(proxyDriver);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in registering " + TracingProxyDriver.class + ": " + e, e);
        }
    }

    private static class UrlHandler {
        private static final String SYNTAX_TEXT = "proxy URL syntax: \"jdbc:proxy:\" + \":\" + optional original driver class name + \":\" + proxied (original) JDBC URL";
        private final String classSpec;
        private final String proxiedURL;
        private final Driver proxiedDriverForProxiedUrl;
        private final Driver proxyDriver;

        UrlHandler(ProxiesManager proxiesManager, String url) throws ProxySetupSQLException {
            String variablePart = url.substring(TracingProxyDriver.JDBC_URL_PREFIX.length());
            int classEndColonPos = variablePart.indexOf(58);
            if (-1 == classEndColonPos) {
                throw new ProxySetupSQLException("Connection URL syntax error: no third colon in proxy URL \"" + url + "\"; (" + SYNTAX_TEXT + ")");
            }
            this.classSpec = variablePart.substring(0, classEndColonPos);
            this.proxiedURL = variablePart.substring(1 + classEndColonPos);
            if (!"".equals(this.classSpec)) {
                try {
                    Class.forName(this.classSpec);
                }
                catch (ClassNotFoundException e) {
                    throw new ProxySetupSQLException("Couldn't load class \"" + this.classSpec + "\" (from proxy driver URL \"" + url + "\" (between second and third colons)): " + e, e);
                }
            }
            try {
                reporter.setupMessage("Proxy calling DriverManager.getDriver(...) for proxied URL \"" + this.proxiedURL + "\".");
                this.proxiedDriverForProxiedUrl = DriverManager.getDriver(this.proxiedURL);
                reporter.setupMessage("DriverManager.getDriver( \"" + this.proxiedURL + "\" ) returned a(n) " + this.proxiedDriverForProxiedUrl.getClass().getName() + ": " + this.proxiedDriverForProxiedUrl + ".");
            }
            catch (SQLException e) {
                String message = "Error getting driver from DriverManager for proxied URL \"" + this.proxiedURL + "\" (from proxy driver URL \"" + url + "\" (after third colon)): " + e;
                reporter.setupMessage(message);
                throw new ProxySetupSQLException(message, e);
            }
            this.proxyDriver = proxiesManager.getProxyInstanceForOriginal(this.proxiedDriverForProxiedUrl, Driver.class);
        }

        public String getProxiedUrl() {
            return this.proxiedURL;
        }

        public Driver getProxiedDriver() {
            return this.proxiedDriverForProxiedUrl;
        }

        public Driver getProxyDriver() {
            return this.proxyDriver;
        }
    }
}

