/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.proxy;

import com.dremio.jdbc.proxy.InvocationReporter;
import com.dremio.jdbc.proxy.TracingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.IdentityHashMap;
import java.util.Map;

class ProxiesManager {
    private final InvocationReporter reporter;
    private Map<Class<?>, Class<Proxy>> interfacesToProxyClassesMap = new IdentityHashMap();
    private Map<Object, Object> proxiedsToProxiesMap = new IdentityHashMap<Object, Object>();

    public ProxiesManager(InvocationReporter reporter) {
        this.reporter = reporter;
    }

    private Class<Proxy> getProxyClassForInterface(Class<?> interfaceType) {
        assert (interfaceType.isInterface());
        Class<Proxy> proxyReturnClass = this.interfacesToProxyClassesMap.get(interfaceType);
        if (null == proxyReturnClass) {
            Class<?> newProxyReturnClass = Proxy.getProxyClass(interfaceType.getClassLoader(), interfaceType);
            this.interfacesToProxyClassesMap.put(interfaceType, newProxyReturnClass);
            proxyReturnClass = newProxyReturnClass;
        }
        return proxyReturnClass;
    }

    public <INTF> INTF getProxyInstanceForOriginal(INTF originalInstance, Class<?> declaredType) {
        Object proxyInstance;
        assert (declaredType.isAssignableFrom(originalInstance.getClass())) : "toBeProxied is of class (" + originalInstance.getClass().getName() + ") that doesn't implement specified interface " + declaredType.getName();
        Object existingProxy = this.proxiedsToProxiesMap.get(originalInstance);
        if (null != existingProxy) {
            proxyInstance = existingProxy;
        } else {
            Class<Proxy> proxyReturnClass = this.getProxyClassForInterface(declaredType);
            TracingInvocationHandler<INTF> callHandler = new TracingInvocationHandler<INTF>(this, this.reporter, originalInstance, declaredType);
            try {
                Proxy newProxyInstance = proxyReturnClass.getConstructor(InvocationHandler.class).newInstance(callHandler);
                this.proxiedsToProxiesMap.put(originalInstance, newProxyInstance);
                proxyInstance = newProxyInstance;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error creating proxy for " + declaredType + ": " + e, e);
            }
        }
        return (INTF)proxyInstance;
    }
}

