/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.common.util.MajorTypeHelper;
import cdjd.com.dremio.exec.proto.UserProtos;
import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.calcite.avatica.ColumnMetaData;
import com.dremio.jdbc.impl.BasicList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DremioColumnMetaDataList
extends BasicList<ColumnMetaData> {
    static final Logger logger = LoggerFactory.getLogger(DremioColumnMetaDataList.class);
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public ColumnMetaData get(int index) {
        return this.columns.get(index);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(String sqlTypeName) {
        int jdbcTypeId = Types.getJdbcTypeCode(sqlTypeName);
        return ColumnMetaData.scalar(jdbcTypeId, sqlTypeName, ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(List<UserProtos.ResultColumnMetadata> metadata) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(metadata.size());
        int offset = 0;
        for (UserProtos.ResultColumnMetadata m3 : metadata) {
            ColumnMetaData.AvaticaType bundledSqlDataType = DremioColumnMetaDataList.getAvaticaType(m3.getDataType());
            newColumns.add(new ColumnMetaData(offset, m3.getAutoIncrement(), m3.getCaseSensitivity(), m3.getSearchability() != UserProtos.ColumnSearchability.NONE, m3.getIsCurrency(), m3.getIsNullable() ? 1 : 0, m3.getSigned(), m3.getDisplaySize(), m3.getLabel(), m3.getColumnName(), m3.getSchemaName(), m3.getPrecision(), m3.getScale(), m3.getTableName(), m3.getCatalogName(), bundledSqlDataType, m3.getUpdatability() == UserProtos.ColumnUpdatability.READ_ONLY, m3.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m3.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m3.getClassName()));
            ++offset;
        }
        this.columns = ImmutableList.copyOf(newColumns);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(TypeProtos.MajorType rpcDateType) {
        String sqlTypeName = Types.getSqlTypeName(rpcDateType);
        int jdbcTypeId = Types.getJdbcTypeCode(sqlTypeName);
        return ColumnMetaData.scalar(jdbcTypeId, sqlTypeName, ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(String catalogName, String schemaName, String tableName, BatchSchema schema, List<Class<?>> getObjectClasses) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(schema.getFieldCount());
        for (int colOffset = 0; colOffset < schema.getFieldCount(); ++colOffset) {
            int nullability;
            Field field = schema.getColumn(colOffset);
            Class<?> objectClass = getObjectClasses.get(colOffset);
            String columnName = field.getName();
            TypeProtos.MajorType rpcDataType = MajorTypeHelper.getMajorTypeForField(field);
            ColumnMetaData.AvaticaType bundledSqlDataType = DremioColumnMetaDataList.getAvaticaType(rpcDataType);
            String columnClassName = objectClass.getName();
            switch (rpcDataType.getMode()) {
                case OPTIONAL: {
                    nullability = 1;
                    break;
                }
                case REQUIRED: {
                    nullability = 0;
                    break;
                }
                case REPEATED: {
                    nullability = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected new DataMode value '" + rpcDataType.getMode() + "'"));
                }
            }
            boolean isSigned = Types.isJdbcSignedType(rpcDataType);
            int precision = Types.getPrecision(rpcDataType);
            int scale = Types.getScale(rpcDataType);
            int displaySize = Types.getJdbcDisplaySize(rpcDataType);
            ColumnMetaData col = new ColumnMetaData(colOffset, false, false, true, false, nullability, isSigned, displaySize, columnName, columnName, schemaName, precision, scale, tableName, catalogName, bundledSqlDataType, true, false, false, columnClassName);
            newColumns.add(col);
        }
        this.columns = newColumns;
    }

    @Override
    public boolean contains(Object o) {
        return this.columns.contains(o);
    }

    @Override
    public Iterator<ColumnMetaData> iterator() {
        return this.columns.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.columns.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.columns.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.columns.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.columns.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.columns.lastIndexOf(o);
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator() {
        return this.columns.listIterator();
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator(int index) {
        return this.columns.listIterator(index);
    }

    @Override
    public List<ColumnMetaData> subList(int fromIndex, int toIndex) {
        return this.columns.subList(fromIndex, toIndex);
    }
}

