/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.exec.record.RecordBatchLoader;
import cdjd.com.dremio.exec.vector.accessor.BoundCheckingAccessor;
import cdjd.com.dremio.exec.vector.accessor.SqlAccessorBuilder;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.calcite.avatica.util.Cursor;
import com.dremio.jdbc.JdbcApiSqlException;
import com.dremio.jdbc.impl.BasicList;
import com.dremio.jdbc.impl.DremioCursor;
import com.dremio.jdbc.impl.SqlAccessorWrapper;
import com.dremio.jdbc.impl.TypeConvertingSqlAccessor;
import java.sql.SQLException;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DremioAccessorList
extends BasicList<Cursor.Accessor> {
    private static final Logger logger = LoggerFactory.getLogger(DremioAccessorList.class);
    private static final int NULL_LAST_COLUMN_INDEX = -2;
    private SqlAccessorWrapper[] accessors = new SqlAccessorWrapper[0];
    private int rowLastColumnOffset = -2;

    DremioAccessorList() {
    }

    void clearLastColumnIndexedInRow() {
        this.rowLastColumnOffset = -2;
    }

    void generateAccessors(DremioCursor cursor, RecordBatchLoader currentBatch, TimeZone defaultTz) {
        int cnt = currentBatch.getSchema().getFieldCount();
        this.accessors = new SqlAccessorWrapper[cnt];
        for (int i = 0; i < cnt; ++i) {
            Object vector = currentBatch.getValueAccessorById(null, i).getValueVector();
            TypeConvertingSqlAccessor acc = new TypeConvertingSqlAccessor(new BoundCheckingAccessor((ValueVector)vector, SqlAccessorBuilder.getSqlAccessor(vector, defaultTz)));
            this.accessors[i] = new SqlAccessorWrapper(acc, cursor);
        }
        this.clearLastColumnIndexedInRow();
    }

    @Override
    public SqlAccessorWrapper get(int accessorOffset) {
        SqlAccessorWrapper accessor = this.accessors[accessorOffset];
        this.rowLastColumnOffset = accessorOffset;
        return accessor;
    }

    boolean wasNull() throws SQLException {
        if (-2 == this.rowLastColumnOffset) {
            throw new JdbcApiSqlException("ResultSet.wasNull() called without a preceding call to a column getter method since the last call to ResultSet.next()");
        }
        return this.accessors[this.rowLastColumnOffset].wasNull();
    }

    @Override
    public int size() {
        return this.accessors.length;
    }
}

