/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.util.internal;

import cdjd.org.jboss.netty.logging.InternalLogger;
import cdjd.org.jboss.netty.logging.InternalLoggerFactory;
import cdjd.org.jboss.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final String OSNAME = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    private static final File WORKDIR;

    private static File tmpdir() {
        File f;
        try {
            f = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("cdjd.io.netty.tmpdir"));
            if (f != null) {
                logger.debug("-Dio.netty.tmpdir: " + f);
                return f;
            }
            f = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (f != null) {
                logger.debug("-Dio.netty.tmpdir: " + f + " (java.io.tmpdir)");
                return f;
            }
            if (NativeLibraryLoader.isWindows()) {
                f = NativeLibraryLoader.toDirectory(System.getenv("TEMP"));
                if (f != null) {
                    logger.debug("-Dio.netty.tmpdir: " + f + " (%TEMP%)");
                    return f;
                }
                String userprofile = System.getenv("USERPROFILE");
                if (userprofile != null) {
                    f = NativeLibraryLoader.toDirectory(userprofile + "\\AppData\\Local\\Temp");
                    if (f != null) {
                        logger.debug("-Dio.netty.tmpdir: " + f + " (%USERPROFILE%\\AppData\\Local\\Temp)");
                        return f;
                    }
                    f = NativeLibraryLoader.toDirectory(userprofile + "\\Local Settings\\Temp");
                    if (f != null) {
                        logger.debug("-Dio.netty.tmpdir: " + f + " (%USERPROFILE%\\Local Settings\\Temp)");
                        return f;
                    }
                }
            } else {
                f = NativeLibraryLoader.toDirectory(System.getenv("TMPDIR"));
                if (f != null) {
                    logger.debug("-Dio.netty.tmpdir: " + f + " ($TMPDIR)");
                    return f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        f = NativeLibraryLoader.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: " + f);
        return f;
    }

    private static File toDirectory(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            return null;
        }
        try {
            return f.getAbsoluteFile();
        }
        catch (Exception ignored) {
            return f;
        }
    }

    private static boolean isWindows() {
        return OSNAME.startsWith("windows");
    }

    private static boolean isOSX() {
        return OSNAME.startsWith("macosx") || OSNAME.startsWith("osx");
    }

    /*
     * Loose catch block
     */
    public static void load(String name, ClassLoader loader) {
        block25: {
            IOException ignore22;
            boolean loaded;
            File tmpFile;
            OutputStream out;
            InputStream in;
            block23: {
                int length;
                String libname = System.mapLibraryName(name);
                String path = NATIVE_RESOURCE_HOME + libname;
                URL url = loader.getResource(path);
                if (url == null && NativeLibraryLoader.isOSX()) {
                    url = path.endsWith(".jnilib") ? loader.getResource("META-INF/native/lib" + name + ".dynlib") : loader.getResource("META-INF/native/lib" + name + ".jnilib");
                }
                if (url == null) {
                    System.loadLibrary(name);
                    return;
                }
                int index = libname.lastIndexOf(46);
                String prefix = libname.substring(0, index);
                String suffix = libname.substring(index, libname.length());
                in = null;
                out = null;
                tmpFile = null;
                loaded = false;
                tmpFile = File.createTempFile(prefix, suffix, WORKDIR);
                in = url.openStream();
                out = new FileOutputStream(tmpFile);
                byte[] buffer = new byte[8192];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
                out.flush();
                out.close();
                out = null;
                System.load(tmpFile.getPath());
                loaded = true;
                Object var15_15 = null;
                if (in == null) break block23;
                try {
                    in.close();
                }
                catch (IOException ignore22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore22) {
                    // empty catch block
                }
            }
            if (tmpFile == null) break block25;
            if (loaded) {
                tmpFile.deleteOnExit();
            } else if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            break block25;
            {
                catch (Exception e) {
                    throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("could not load a native library: " + name).initCause(e);
                }
            }
            catch (Throwable throwable) {
                IOException ignore22;
                Object var15_16 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore22) {
                        // empty catch block
                    }
                }
                if (tmpFile != null) {
                    if (loaded) {
                        tmpFile.deleteOnExit();
                    } else if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
                throw throwable;
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        String workdir = SystemPropertyUtil.get("cdjd.io.netty.native.workdir");
        if (workdir != null) {
            File f = new File(workdir);
            if (!f.exists()) {
                f.mkdirs();
            }
            try {
                f = f.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = f;
            logger.debug("-Dio.netty.netty.workdir: " + WORKDIR);
        } else {
            WORKDIR = NativeLibraryLoader.tmpdir();
            logger.debug("-Dio.netty.netty.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
    }
}

