/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.codec.marshalling;

import cdjd.org.jboss.marshalling.ByteInput;
import cdjd.org.jboss.marshalling.Unmarshaller;
import cdjd.org.jboss.netty.buffer.ChannelBuffer;
import cdjd.org.jboss.netty.channel.Channel;
import cdjd.org.jboss.netty.channel.ChannelHandlerContext;
import cdjd.org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import cdjd.org.jboss.netty.handler.codec.marshalling.ChannelBufferByteInput;
import cdjd.org.jboss.netty.handler.codec.marshalling.UnmarshallerProvider;

public class MarshallingDecoder
extends LengthFieldBasedFrameDecoder {
    private final UnmarshallerProvider provider;

    public MarshallingDecoder(UnmarshallerProvider provider) {
        this(provider, 0x100000);
    }

    public MarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        ChannelBuffer frame = (ChannelBuffer)super.decode(ctx, channel, buffer);
        if (frame == null) {
            return null;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        ChannelBufferByteInput input = new ChannelBufferByteInput(frame);
        try {
            unmarshaller.start((ByteInput)input);
            Object obj = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = obj;
            return object;
        }
        finally {
            unmarshaller.close();
        }
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

