/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.codec.http;

import cdjd.org.jboss.netty.handler.codec.http.DefaultCookie;
import cdjd.org.jboss.netty.handler.codec.http.cookie.ClientCookieEncoder;
import cdjd.org.jboss.netty.handler.codec.http.cookie.Cookie;
import cdjd.org.jboss.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.Set;
import java.util.TreeSet;

public class CookieEncoder {
    private final Set<cdjd.org.jboss.netty.handler.codec.http.Cookie> cookies = new TreeSet<cdjd.org.jboss.netty.handler.codec.http.Cookie>();
    private final boolean server;
    private final boolean strict;

    public CookieEncoder(boolean server) {
        this(server, false);
    }

    public CookieEncoder(boolean server, boolean strict) {
        this.server = server;
        this.strict = strict;
    }

    public void addCookie(String name, String value) {
        this.cookies.add(new DefaultCookie(name, value));
    }

    public void addCookie(cdjd.org.jboss.netty.handler.codec.http.Cookie cookie) {
        this.cookies.add(cookie);
    }

    public String encode() {
        String answer = this.server ? this.encodeServerSide() : this.encodeClientSide();
        this.cookies.clear();
        return answer;
    }

    private String encodeServerSide() {
        if (this.cookies.size() > 1) {
            throw new IllegalStateException("encode() can encode only one cookie on server mode: " + this.cookies.size() + " cookies added");
        }
        cdjd.org.jboss.netty.handler.codec.http.Cookie cookie = this.cookies.isEmpty() ? null : this.cookies.iterator().next();
        ServerCookieEncoder encoder = this.strict ? ServerCookieEncoder.STRICT : ServerCookieEncoder.LAX;
        return encoder.encode((Cookie)cookie);
    }

    private String encodeClientSide() {
        ClientCookieEncoder encoder = this.strict ? ClientCookieEncoder.STRICT : ClientCookieEncoder.LAX;
        return encoder.encode(this.cookies);
    }
}

