/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.zookeeper.server.auth;

import cdjd.org.apache.zookeeper.KeeperException;
import cdjd.org.apache.zookeeper.server.ServerCnxn;
import cdjd.org.apache.zookeeper.server.auth.AuthenticationProvider;
import cdjd.org.apache.zookeeper.server.auth.KerberosName;

public class SASLAuthenticationProvider
implements AuthenticationProvider {
    @Override
    public String getScheme() {
        return "sasl";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        return KeeperException.Code.AUTHFAILED;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        if (System.getProperty("zookeeper.superUser") != null) {
            return id.equals(System.getProperty("zookeeper.superUser")) || id.equals(aclExpr);
        }
        return id.equals("super") || id.equals(aclExpr);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        try {
            new KerberosName(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

