/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.x.discovery;

import cdjd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Maps;
import cdjd.org.apache.curator.x.discovery.ServiceInstanceBuilder;
import cdjd.org.apache.curator.x.discovery.ServiceType;
import cdjd.org.apache.curator.x.discovery.UriSpec;
import cdjd.org.codehaus.jackson.annotate.JsonTypeInfo;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public class ServiceInstance<T> {
    private final String name;
    private final String id;
    private final String address;
    private final Integer port;
    private final Integer sslPort;
    private final T payload;
    private final long registrationTimeUTC;
    private final ServiceType serviceType;
    private final UriSpec uriSpec;
    private final boolean enabled;

    public static <T> ServiceInstanceBuilder<T> builder() throws Exception {
        String address = null;
        Collection<InetAddress> ips = ServiceInstanceBuilder.getAllLocalIPs();
        if (ips.size() > 0) {
            address = ips.iterator().next().getHostAddress();
        }
        String id = UUID.randomUUID().toString();
        return new ServiceInstanceBuilder().address(address).id(id).registrationTimeUTC(System.currentTimeMillis());
    }

    public ServiceInstance(String name, String id, String address, Integer port, Integer sslPort, T payload, long registrationTimeUTC, ServiceType serviceType, UriSpec uriSpec) {
        this(name, id, address, port, sslPort, payload, registrationTimeUTC, serviceType, uriSpec, true);
    }

    public ServiceInstance(String name, String id, String address, Integer port, Integer sslPort, T payload, long registrationTimeUTC, ServiceType serviceType, UriSpec uriSpec, boolean enabled) {
        name = Preconditions.checkNotNull(name, "name cannot be null");
        id = Preconditions.checkNotNull(id, "id cannot be null");
        this.serviceType = serviceType;
        this.uriSpec = uriSpec;
        this.name = name;
        this.id = id;
        this.address = address;
        this.port = port;
        this.sslPort = sslPort;
        this.payload = payload;
        this.registrationTimeUTC = registrationTimeUTC;
        this.enabled = enabled;
    }

    ServiceInstance() {
        this("", "", null, null, null, null, 0L, ServiceType.DYNAMIC, null, true);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getSslPort() {
        return this.sslPort;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, defaultImpl=Object.class)
    public T getPayload() {
        return this.payload;
    }

    public long getRegistrationTimeUTC() {
        return this.registrationTimeUTC;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public UriSpec getUriSpec() {
        return this.uriSpec;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String buildUriSpec() {
        return this.buildUriSpec(Maps.<String, Object>newHashMap());
    }

    public String buildUriSpec(Map<String, Object> variables) {
        return this.uriSpec != null ? this.uriSpec.build(this, variables) : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInstance that = (ServiceInstance)o;
        if (this.registrationTimeUTC != that.registrationTimeUTC) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.serviceType != that.serviceType) {
            return false;
        }
        if (this.sslPort != null ? !this.sslPort.equals(that.sslPort) : that.sslPort != null) {
            return false;
        }
        if (this.uriSpec != null ? !this.uriSpec.equals(that.uriSpec) : that.uriSpec != null) {
            return false;
        }
        return this.enabled == that.enabled;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.sslPort != null ? this.sslPort.hashCode() : 0);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (int)(this.registrationTimeUTC ^ this.registrationTimeUTC >>> 32);
        result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
        result = 31 * result + (this.uriSpec != null ? this.uriSpec.hashCode() : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ServiceInstance{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", address='" + this.address + '\'' + ", port=" + this.port + ", sslPort=" + this.sslPort + ", payload=" + this.payload + ", registrationTimeUTC=" + this.registrationTimeUTC + ", serviceType=" + (Object)((Object)this.serviceType) + ", uriSpec=" + this.uriSpec + ", enabled=" + this.enabled + '}';
    }
}

