/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.listen;

import cdjd.com.google.common.base.Function;
import cdjd.org.apache.curator.framework.listen.Listenable;
import cdjd.org.apache.curator.framework.listen.ListenerEntry;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Maps;
import cdjd.org.apache.curator.shaded.com.google.common.util.concurrent.MoreExecutors;
import cdjd.org.apache.curator.utils.ThreadUtils;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerContainer<T>
implements Listenable<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<T, ListenerEntry<T>> listeners = Maps.newConcurrentMap();

    @Override
    public void addListener(T listener) {
        this.addListener(listener, MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(T listener, Executor executor) {
        this.listeners.put(listener, new ListenerEntry<T>(listener, executor));
    }

    @Override
    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void forEach(final Function<T, Void> function) {
        for (final ListenerEntry<T> entry : this.listeners.values()) {
            entry.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        function.apply(entry.listener);
                    }
                    catch (Throwable e) {
                        ThreadUtils.checkInterrupted(e);
                        ListenerContainer.this.log.error(String.format("Listener (%s) threw an exception", entry.listener), e);
                    }
                }
            });
        }
    }
}

