/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.imps;

import cdjd.org.apache.curator.RetryLoop;
import cdjd.org.apache.curator.drivers.OperationTrace;
import cdjd.org.apache.curator.framework.api.BackgroundCallback;
import cdjd.org.apache.curator.framework.api.BackgroundPathable;
import cdjd.org.apache.curator.framework.api.CuratorEventType;
import cdjd.org.apache.curator.framework.api.CuratorWatcher;
import cdjd.org.apache.curator.framework.api.ErrorListenerPathable;
import cdjd.org.apache.curator.framework.api.ExistsBuilder;
import cdjd.org.apache.curator.framework.api.ExistsBuilderMain;
import cdjd.org.apache.curator.framework.api.Pathable;
import cdjd.org.apache.curator.framework.api.UnhandledErrorListener;
import cdjd.org.apache.curator.framework.imps.BackgroundOperation;
import cdjd.org.apache.curator.framework.imps.Backgrounding;
import cdjd.org.apache.curator.framework.imps.CreateBuilderImpl;
import cdjd.org.apache.curator.framework.imps.CuratorEventImpl;
import cdjd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import cdjd.org.apache.curator.framework.imps.OperationAndData;
import cdjd.org.apache.curator.framework.imps.Watching;
import cdjd.org.apache.curator.utils.ZKPaths;
import cdjd.org.apache.zookeeper.AsyncCallback;
import cdjd.org.apache.zookeeper.KeeperException;
import cdjd.org.apache.zookeeper.Watcher;
import cdjd.org.apache.zookeeper.data.Stat;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ExistsBuilderImpl
implements ExistsBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Stat> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;
    private boolean createParentContainersIfNeeded;

    ExistsBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.watching = new Watching();
        this.createParentContainersIfNeeded = false;
    }

    @Override
    public ExistsBuilderMain creatingParentContainersIfNeeded() {
        this.createParentContainersIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Stat> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Background");
            AsyncCallback.StatCallback callback = new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setPath(path).setWithWatcher(ExistsBuilderImpl.this.watching.getWatcher() != null).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(ExistsBuilderImpl.this.client, CuratorEventType.EXISTS, rc, path, null, ctx, stat, null, null, null, null);
                    ExistsBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().exists(operationAndData.getData(), true, callback, this.backgrounding.getContext());
            } else {
                this.client.getZooKeeper().exists(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
            }
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e);
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        Stat returnStat = null;
        if (this.backgrounding.inBackground()) {
            OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext());
            if (this.createParentContainersIfNeeded) {
                CreateBuilderImpl.backgroundCreateParentsThenNode(this.client, operationAndData, operationAndData.getData(), this.backgrounding, true);
            } else {
                this.client.processBackgroundOperation(operationAndData, null);
            }
        } else {
            returnStat = this.pathInForeground(path);
        }
        return returnStat;
    }

    private Stat pathInForeground(String path) throws Exception {
        String parent;
        if (this.createParentContainersIfNeeded && !(parent = ZKPaths.getPathAndNode(path).getPath()).equals("/")) {
            OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground-CreateParents");
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ZKPaths.mkdirs(ExistsBuilderImpl.this.client.getZooKeeper(), parent, true, ExistsBuilderImpl.this.client.getAclProvider(), true);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            trace.setPath(path).commit();
        }
        return this.pathInForegroundStandard(path);
    }

    private Stat pathInForegroundStandard(final String path) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground");
        Stat returnStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                Stat returnStat = ExistsBuilderImpl.this.watching.isWatched() ? ExistsBuilderImpl.this.client.getZooKeeper().exists(path, true) : ExistsBuilderImpl.this.client.getZooKeeper().exists(path, ExistsBuilderImpl.this.watching.getWatcher());
                return returnStat;
            }
        });
        trace.setPath(path).setWithWatcher(this.watching.getWatcher() != null).setStat(returnStat).commit();
        return returnStat;
    }
}

