/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.imps;

import cdjd.org.apache.curator.RetryLoop;
import cdjd.org.apache.curator.drivers.OperationTrace;
import cdjd.org.apache.curator.framework.api.BackgroundCallback;
import cdjd.org.apache.curator.framework.api.BackgroundPathable;
import cdjd.org.apache.curator.framework.api.BackgroundVersionable;
import cdjd.org.apache.curator.framework.api.ChildrenDeletable;
import cdjd.org.apache.curator.framework.api.CuratorEventType;
import cdjd.org.apache.curator.framework.api.DeleteBuilder;
import cdjd.org.apache.curator.framework.api.ErrorListenerPathable;
import cdjd.org.apache.curator.framework.api.Pathable;
import cdjd.org.apache.curator.framework.api.UnhandledErrorListener;
import cdjd.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import cdjd.org.apache.curator.framework.api.transaction.OperationType;
import cdjd.org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import cdjd.org.apache.curator.framework.imps.BackgroundOperation;
import cdjd.org.apache.curator.framework.imps.Backgrounding;
import cdjd.org.apache.curator.framework.imps.CuratorEventImpl;
import cdjd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import cdjd.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import cdjd.org.apache.curator.framework.imps.CuratorTransactionImpl;
import cdjd.org.apache.curator.framework.imps.OperationAndData;
import cdjd.org.apache.curator.utils.ThreadUtils;
import cdjd.org.apache.curator.utils.ZKPaths;
import cdjd.org.apache.zookeeper.AsyncCallback;
import cdjd.org.apache.zookeeper.KeeperException;
import cdjd.org.apache.zookeeper.Op;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;
    private boolean deletingChildrenIfNeeded;
    private boolean guaranteed;

    DeleteBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.deletingChildrenIfNeeded = false;
        this.guaranteed = false;
    }

    TransactionDeleteBuilder asTransactionDeleteBuilder(final CuratorTransactionImpl curatorTransaction, final CuratorMultiTransactionRecord transaction) {
        return new TransactionDeleteBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String path) throws Exception {
                String fixedPath = DeleteBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.delete(fixedPath, DeleteBuilderImpl.this.version), OperationType.DELETE, path);
                return curatorTransaction;
            }

            @Override
            public Pathable<CuratorTransactionBridge> withVersion(int version) {
                DeleteBuilderImpl.this.withVersion(version);
                return this;
            }
        };
    }

    @Override
    public ChildrenDeletable guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundVersionable deletingChildrenIfNeeded() {
        this.deletingChildrenIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Background");
            this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    trace.setReturnCode(rc).setPath(path).commit();
                    if (rc == KeeperException.Code.NOTEMPTY.intValue() && DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                        DeleteBuilderImpl.this.backgroundDeleteChildrenThenNode(operationAndData);
                    } else {
                        CuratorEventImpl event = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, rc, path, null, ctx, null, null, null, null, null);
                        DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                    }
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e);
        }
    }

    private void backgroundDeleteChildrenThenNode(final OperationAndData<String> mainOperationAndData) {
        BackgroundOperation<String> operation = new BackgroundOperation<String>(){

            @Override
            public void performBackgroundOperation(OperationAndData<String> dummy) throws Exception {
                try {
                    ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), (String)mainOperationAndData.getData(), false);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                DeleteBuilderImpl.this.client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<String> parentOperation = new OperationAndData<String>(operation, mainOperationAndData.getData(), null, null, this.backgrounding.getContext());
        this.client.queueOperation(parentOperation);
    }

    @Override
    public Void forPath(String path) throws Exception {
        final String unfixedPath = path;
        path = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        DeleteBuilderImpl.this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
                    }
                };
            }
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), errorCallback, this.backgrounding.getContext()), null);
        } else {
            this.pathInForeground(path, unfixedPath);
        }
        return null;
    }

    protected int getVersion() {
        return this.version;
    }

    private void pathInForeground(final String path, String unfixedPath) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DeleteBuilderImpl.this.client.getZooKeeper().delete(path, DeleteBuilderImpl.this.version);
                    }
                    catch (KeeperException.NotEmptyException e) {
                        if (DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                            ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), path, true);
                        }
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            if ((RetryLoop.isRetryException(e) || e instanceof InterruptedException) && this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
            }
            throw e;
        }
        trace.setPath(path).commit();
    }
}

