/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.util;

import cdjd.io.netty.util.internal.PlatformDependent;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BaseLargeVariableWidthVector;
import cdjd.org.apache.arrow.vector.BaseVariableWidthVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.NullVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.compare.TypeEqualsVisitor;
import cdjd.org.apache.arrow.vector.compare.VectorVisitor;
import cdjd.org.apache.arrow.vector.complex.DenseUnionVector;
import cdjd.org.apache.arrow.vector.complex.FixedSizeListVector;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVector;
import cdjd.org.apache.arrow.vector.complex.UnionVector;
import java.util.HashSet;

class VectorAppender
implements VectorVisitor<ValueVector, Void> {
    private final ValueVector targetVector;
    private final TypeEqualsVisitor typeVisitor;

    VectorAppender(ValueVector targetVector) {
        this.targetVector = targetVector;
        this.typeVisitor = new TypeEqualsVisitor(targetVector, false, true);
    }

    @Override
    public ValueVector visit(BaseFixedWidthVector deltaVector, Void value) {
        Preconditions.checkArgument(this.targetVector.getField().getType().equals(deltaVector.getField().getType()), "The targetVector to append must have the same type as the targetVector being appended");
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        while (this.targetVector.getValueCapacity() < newValueCount) {
            this.targetVector.reAlloc();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        PlatformDependent.copyMemory(deltaVector.getDataBuffer().memoryAddress(), this.targetVector.getDataBuffer().memoryAddress() + (long)(deltaVector.getTypeWidth() * this.targetVector.getValueCount()), deltaVector.getTypeWidth() * deltaVector.getValueCount());
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(BaseVariableWidthVector deltaVector, Void value) {
        Preconditions.checkArgument(this.targetVector.getField().getType().equals(deltaVector.getField().getType()), "The targetVector to append must have the same type as the targetVector being appended");
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        int targetDataSize = this.targetVector.getOffsetBuffer().getInt((long)this.targetVector.getValueCount() * 4L);
        int deltaDataSize = deltaVector.getOffsetBuffer().getInt((long)deltaVector.getValueCount() * 4L);
        int newValueCapacity = targetDataSize + deltaDataSize;
        while (this.targetVector.getValueCapacity() < newValueCount) {
            this.targetVector.reAlloc();
        }
        while (this.targetVector.getDataBuffer().capacity() < (long)newValueCapacity) {
            ((BaseVariableWidthVector)this.targetVector).reallocDataBuffer();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        PlatformDependent.copyMemory(deltaVector.getDataBuffer().memoryAddress(), this.targetVector.getDataBuffer().memoryAddress() + (long)targetDataSize, deltaDataSize);
        PlatformDependent.copyMemory(deltaVector.getOffsetBuffer().memoryAddress() + 4L, this.targetVector.getOffsetBuffer().memoryAddress() + (long)((this.targetVector.getValueCount() + 1) * 4), deltaVector.getValueCount() * 4);
        for (int i = 0; i < deltaVector.getValueCount(); ++i) {
            int oldOffset = this.targetVector.getOffsetBuffer().getInt((long)(this.targetVector.getValueCount() + 1 + i) * 4L);
            this.targetVector.getOffsetBuffer().setInt((long)(this.targetVector.getValueCount() + 1 + i) * 4L, oldOffset + targetDataSize);
        }
        ((BaseVariableWidthVector)this.targetVector).setLastSet(newValueCount - 1);
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(BaseLargeVariableWidthVector left, Void value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueVector visit(ListVector deltaVector, Void value) {
        Preconditions.checkArgument(this.typeVisitor.equals(deltaVector), "The targetVector to append must have the same type as the targetVector being appended");
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        int targetListSize = this.targetVector.getOffsetBuffer().getInt((long)this.targetVector.getValueCount() * 4L);
        int deltaListSize = deltaVector.getOffsetBuffer().getInt((long)deltaVector.getValueCount() * 4L);
        ListVector targetListVector = (ListVector)this.targetVector;
        targetListVector.getDataVector().setValueCount(targetListSize);
        deltaVector.getDataVector().setValueCount(deltaListSize);
        while (this.targetVector.getValueCapacity() < newValueCount) {
            this.targetVector.reAlloc();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        PlatformDependent.copyMemory(deltaVector.getOffsetBuffer().memoryAddress() + 4L, this.targetVector.getOffsetBuffer().memoryAddress() + (long)((this.targetVector.getValueCount() + 1) * 4), (long)deltaVector.getValueCount() * 4L);
        for (int i = 0; i < deltaVector.getValueCount(); ++i) {
            int oldOffset = this.targetVector.getOffsetBuffer().getInt((long)(this.targetVector.getValueCount() + 1 + i) * 4L);
            this.targetVector.getOffsetBuffer().setInt((long)(this.targetVector.getValueCount() + 1 + i) * 4L, oldOffset + targetListSize);
        }
        targetListVector.setLastSet(newValueCount - 1);
        VectorAppender innerAppender = new VectorAppender(targetListVector.getDataVector());
        deltaVector.getDataVector().accept(innerAppender, null);
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(FixedSizeListVector deltaVector, Void value) {
        Preconditions.checkArgument(this.typeVisitor.equals(deltaVector), "The vector to append must have the same type as the targetVector being appended");
        FixedSizeListVector targetListVector = (FixedSizeListVector)this.targetVector;
        Preconditions.checkArgument(targetListVector.getListSize() == deltaVector.getListSize(), "FixedSizeListVector must have the same list size to append");
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        int targetListSize = targetListVector.getValueCount() * targetListVector.getListSize();
        int deltaListSize = deltaVector.getValueCount() * deltaVector.getListSize();
        targetListVector.getDataVector().setValueCount(targetListSize);
        deltaVector.getDataVector().setValueCount(deltaListSize);
        while (this.targetVector.getValueCapacity() < newValueCount) {
            this.targetVector.reAlloc();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        VectorAppender innerAppender = new VectorAppender(targetListVector.getDataVector());
        deltaVector.getDataVector().accept(innerAppender, null);
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(NonNullableStructVector deltaVector, Void value) {
        Preconditions.checkArgument(this.typeVisitor.equals(deltaVector), "The vector to append must have the same type as the targetVector being appended");
        NonNullableStructVector targetStructVector = (NonNullableStructVector)this.targetVector;
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        while (this.targetVector.getValueCapacity() < newValueCount) {
            this.targetVector.reAlloc();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        for (int i = 0; i < targetStructVector.getChildrenFromFields().size(); ++i) {
            ValueVector targetChild = targetStructVector.getVectorById(i);
            ValueVector deltaChild = deltaVector.getVectorById(i);
            targetChild.setValueCount(targetStructVector.getValueCount());
            deltaChild.setValueCount(deltaVector.getValueCount());
            VectorAppender innerAppender = new VectorAppender(targetChild);
            deltaChild.accept(innerAppender, null);
        }
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(UnionVector deltaVector, Void value) {
        int i;
        Preconditions.checkArgument(this.targetVector.getMinorType() == deltaVector.getMinorType(), "The vector to append must have the same type as the targetVector being appended");
        UnionVector targetUnionVector = (UnionVector)this.targetVector;
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        while (targetUnionVector.getValueCapacity() < newValueCount) {
            targetUnionVector.reAlloc();
        }
        PlatformDependent.copyMemory(deltaVector.getValidityBufferAddress(), targetUnionVector.getValidityBufferAddress() + (long)this.targetVector.getValueCount(), deltaVector.getValueCount());
        HashSet<Integer> targetTypes = new HashSet<Integer>();
        for (int i2 = 0; i2 < targetUnionVector.getValueCount(); ++i2) {
            targetTypes.add(Integer.valueOf(targetUnionVector.getValidityBuffer().getByte(i2)));
        }
        HashSet<Integer> deltaTypes = new HashSet<Integer>();
        for (i = 0; i < deltaVector.getValueCount(); ++i) {
            deltaTypes.add(Integer.valueOf(deltaVector.getValidityBuffer().getByte(i)));
        }
        for (i = 0; i < 127; ++i) {
            if (!targetTypes.contains(i) && !deltaTypes.contains(i)) continue;
            ValueVector targetChild = targetUnionVector.getVectorByType(i);
            if (!targetTypes.contains(i)) {
                while (targetChild.getValueCapacity() < newValueCount) {
                    targetChild.reAlloc();
                }
            }
            if (deltaTypes.contains(i)) {
                ValueVector deltaChild = deltaVector.getVectorByType(i);
                targetChild.setValueCount(targetUnionVector.getValueCount());
                deltaChild.setValueCount(deltaVector.getValueCount());
                VectorAppender innerAppender = new VectorAppender(targetChild);
                deltaChild.accept(innerAppender, null);
            }
            targetChild.setValueCount(newValueCount);
        }
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(DenseUnionVector deltaVector, Void value) {
        int i;
        Preconditions.checkArgument(this.targetVector.getMinorType() == deltaVector.getMinorType(), "The vector to append must have the same type as the targetVector being appended");
        DenseUnionVector targetDenseUnionVector = (DenseUnionVector)this.targetVector;
        int newValueCount = this.targetVector.getValueCount() + deltaVector.getValueCount();
        while (targetDenseUnionVector.getValueCapacity() < newValueCount) {
            targetDenseUnionVector.reAlloc();
        }
        BitVectorHelper.concatBits(this.targetVector.getValidityBuffer(), this.targetVector.getValueCount(), deltaVector.getValidityBuffer(), deltaVector.getValueCount(), this.targetVector.getValidityBuffer());
        PlatformDependent.copyMemory(deltaVector.getTypeBuffer().memoryAddress(), targetDenseUnionVector.getTypeBuffer().memoryAddress() + (long)this.targetVector.getValueCount(), deltaVector.getValueCount());
        for (i = 0; i < deltaVector.getValueCount(); ++i) {
            byte typeId = deltaVector.getTypeId(i);
            ValueVector targetChildVector = targetDenseUnionVector.getVectorByType(typeId);
            int offsetBase = targetChildVector == null ? 0 : targetChildVector.getValueCount();
            int deltaOffset = deltaVector.getOffset(i);
            long index = (long)(this.targetVector.getValueCount() + i) * 4L;
            this.targetVector.getOffsetBuffer().setInt(index, offsetBase + deltaOffset);
        }
        for (i = 0; i <= 127; ++i) {
            ValueVector targetChildVector = targetDenseUnionVector.getVectorByType((byte)i);
            ValueVector deltaChildVector = deltaVector.getVectorByType((byte)i);
            if (targetChildVector == null && deltaChildVector == null) continue;
            if (targetChildVector == null && deltaChildVector != null) {
                targetDenseUnionVector.registerNewTypeId(deltaChildVector.getField());
                targetChildVector = targetDenseUnionVector.addVector((byte)i, deltaChildVector.getField().createVector(targetDenseUnionVector.getAllocator()));
                VectorAppender childAppender = new VectorAppender(targetChildVector);
                deltaChildVector.accept(childAppender, null);
                continue;
            }
            if (targetChildVector != null && deltaChildVector == null) continue;
            TypeEqualsVisitor childTypeVisitor = new TypeEqualsVisitor(targetChildVector, false, false);
            if (!childTypeVisitor.equals(deltaChildVector)) {
                throw new IllegalArgumentException("dense union vectors have different child vector types with type id " + i);
            }
            VectorAppender childAppender = new VectorAppender(targetChildVector);
            deltaChildVector.accept(childAppender, null);
        }
        this.targetVector.setValueCount(newValueCount);
        return this.targetVector;
    }

    @Override
    public ValueVector visit(NullVector deltaVector, Void value) {
        Preconditions.checkArgument(this.targetVector.getField().getType().equals(deltaVector.getField().getType()), "The targetVector to append must have the same type as the targetVector being appended");
        return this.targetVector;
    }
}

