/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.util;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BufferLayout;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.TypeLayout;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.validate.ValidateVectorVisitor;

public class ValueVectorUtility {
    public static String getToString(ValueVector vector, int start, int end) {
        Preconditions.checkNotNull(vector);
        int length = end - start;
        Preconditions.checkArgument(length >= 0);
        Preconditions.checkArgument(start >= 0);
        Preconditions.checkArgument(end <= vector.getValueCount());
        if (length == 0) {
            return "[]";
        }
        int window = 10;
        boolean skipComma = false;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = start; i < end; ++i) {
            if (skipComma) {
                skipComma = false;
            }
            if (i - start >= 10 && i < end - 10) {
                sb.append("...");
                i = end - 10 - 1;
                skipComma = true;
            } else {
                sb.append(vector.getObject(i));
            }
            if (i == end - 1) {
                sb.append(']');
                continue;
            }
            if (!skipComma) {
                sb.append(',');
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void validate(FieldVector vector) {
        Preconditions.checkNotNull(vector);
        ArrowType arrowType = vector.getField().getType();
        int typeBufferCount = TypeLayout.getTypeBufferCount(arrowType);
        TypeLayout typeLayout = TypeLayout.getTypeLayout(arrowType);
        if (vector.getValueCount() < 0) {
            throw new IllegalArgumentException("vector valueCount is negative");
        }
        if (vector.getFieldBuffers().size() != typeBufferCount) {
            throw new IllegalArgumentException(String.format("Expected %s buffers in vector of type %s, got %s", typeBufferCount, vector.getField().getType().toString(), vector.getBufferSize()));
        }
        for (int i = 0; i < typeBufferCount; ++i) {
            ArrowBuf buffer = vector.getFieldBuffers().get(i);
            BufferLayout bufferLayout = typeLayout.getBufferLayouts().get(i);
            if (buffer == null) continue;
            int minBufferSize = vector.getValueCount() * bufferLayout.getTypeBitWidth();
            if (buffer.capacity() >= (long)(minBufferSize / 8)) continue;
            throw new IllegalArgumentException(String.format("Buffer #%s too small in vector of type %sand valueCount %s : expected at least %s byte(s), got %s", i, vector.getField().getType().toString(), vector.getValueCount(), minBufferSize, buffer.capacity()));
        }
        ValidateVectorVisitor visitor = new ValidateVectorVisitor();
        vector.accept(visitor, null);
    }

    public static void preAllocate(VectorSchemaRoot root, int targetSize) {
        for (ValueVector valueVector : root.getFieldVectors()) {
            if (!(valueVector instanceof BaseFixedWidthVector)) continue;
            ((BaseFixedWidthVector)valueVector).allocateNew(targetSize);
        }
    }

    public static void ensureCapacity(VectorSchemaRoot root, int targetCapacity) {
        for (ValueVector valueVector : root.getFieldVectors()) {
            if (!(valueVector instanceof BaseFixedWidthVector)) continue;
            while (valueVector.getValueCapacity() < targetCapacity) {
                valueVector.reAlloc();
            }
        }
    }
}

