/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.util;

import cdjd.io.netty.util.internal.PlatformDependent;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class DecimalUtility {
    public static final int DECIMAL_BYTE_LENGTH = 16;
    public static final byte[] zeroes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] minus_one = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    private DecimalUtility() {
    }

    public static BigDecimal getBigDecimalFromArrowBuf(ArrowBuf bytebuf, int index, int scale) {
        byte[] value = new byte[16];
        int startIndex = index * 16;
        bytebuf.getBytes((long)startIndex, value, 0, 16);
        int stop = 8;
        for (int i = 0; i < stop; ++i) {
            byte temp = value[i];
            int j = 15 - i;
            value[i] = value[j];
            value[j] = temp;
        }
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal getBigDecimalFromByteBuffer(ByteBuffer bytebuf, int scale) {
        byte[] value = new byte[16];
        bytebuf.get(value);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static byte[] getByteArrayFromArrowBuf(ArrowBuf bytebuf, int index) {
        byte[] value = new byte[16];
        long startIndex = (long)index * 16L;
        bytebuf.getBytes(startIndex, value, 0, 16);
        return value;
    }

    public static boolean checkPrecisionAndScale(BigDecimal value, int vectorPrecision, int vectorScale) {
        if (value.scale() != vectorScale) {
            throw new UnsupportedOperationException("BigDecimal scale must equal that in the Arrow vector: " + value.scale() + " != " + vectorScale);
        }
        if (value.precision() > vectorPrecision) {
            throw new UnsupportedOperationException("BigDecimal precision can not be greater than that in the Arrow vector: " + value.precision() + " > " + vectorPrecision);
        }
        return true;
    }

    public static boolean checkPrecisionAndScale(int decimalPrecision, int decimalScale, int vectorPrecision, int vectorScale) {
        if (decimalScale != vectorScale) {
            throw new UnsupportedOperationException("BigDecimal scale must equal that in the Arrow vector: " + decimalScale + " != " + vectorScale);
        }
        if (decimalPrecision > vectorPrecision) {
            throw new UnsupportedOperationException("BigDecimal precision can not be greater than that in the Arrow vector: " + decimalPrecision + " > " + vectorPrecision);
        }
        return true;
    }

    public static void writeBigDecimalToArrowBuf(BigDecimal value, ArrowBuf bytebuf, int index) {
        byte[] bytes = value.unscaledValue().toByteArray();
        DecimalUtility.writeByteArrayToArrowBufHelper(bytes, bytebuf, index);
    }

    public static void writeLongToArrowBuf(long value, ArrowBuf bytebuf, int index) {
        long addressOfValue = bytebuf.memoryAddress() + (long)index * 16L;
        PlatformDependent.putLong(addressOfValue, value);
        long padValue = Long.signum(value) == -1 ? -1L : 0L;
        PlatformDependent.putLong(addressOfValue + 8L, padValue);
    }

    public static void writeByteArrayToArrowBuf(byte[] bytes, ArrowBuf bytebuf, int index) {
        DecimalUtility.writeByteArrayToArrowBufHelper(bytes, bytebuf, index);
    }

    private static void writeByteArrayToArrowBufHelper(byte[] bytes, ArrowBuf bytebuf, int index) {
        long startIndex = (long)index * 16L;
        if (bytes.length > 16) {
            throw new UnsupportedOperationException("Decimal size greater than 16 bytes");
        }
        byte[] bytesLE = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytesLE[i] = bytes[bytes.length - 1 - i];
        }
        byte[] padByes = bytes[0] < 0 ? minus_one : zeroes;
        bytebuf.setBytes(startIndex, bytesLE, 0, (long)bytes.length);
        bytebuf.setBytes(startIndex + (long)bytes.length, padByes, 0, (long)(16 - bytes.length));
    }
}

