/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc.message;

import cdjd.com.google.flatbuffers.FlatBufferBuilder;
import cdjd.org.apache.arrow.flatbuf.RecordBatch;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.util.DataSizeRoundingUtil;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBuffer;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowMessage;
import cdjd.org.apache.arrow.vector.ipc.message.FBSerializables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowRecordBatch
implements ArrowMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowRecordBatch.class);
    private final int length;
    private final List<ArrowFieldNode> nodes;
    private final List<ArrowBuf> buffers;
    private final List<ArrowBuffer> buffersLayout;
    private boolean closed = false;

    public ArrowRecordBatch(int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        this(length, nodes, buffers, true);
    }

    public ArrowRecordBatch(int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers, boolean alignBuffers) {
        this.length = length;
        this.nodes = nodes;
        this.buffers = buffers;
        ArrayList<ArrowBuffer> arrowBuffers = new ArrayList<ArrowBuffer>(buffers.size());
        long offset = 0L;
        for (ArrowBuf arrowBuf : buffers) {
            arrowBuf.getReferenceManager().retain();
            long size = arrowBuf.readableBytes();
            arrowBuffers.add(new ArrowBuffer(offset, size));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Buffer in RecordBatch at {}, length: {}", (Object)offset, (Object)size);
            }
            offset += size;
            if (!alignBuffers) continue;
            offset = DataSizeRoundingUtil.roundUpTo8Multiple(offset);
        }
        this.buffersLayout = Collections.unmodifiableList(arrowBuffers);
    }

    private ArrowRecordBatch(boolean dummy, int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        this.length = length;
        this.nodes = nodes;
        this.buffers = buffers;
        this.closed = false;
        ArrayList<ArrowBuffer> arrowBuffers = new ArrayList<ArrowBuffer>();
        long offset = 0L;
        for (ArrowBuf arrowBuf : buffers) {
            long size = arrowBuf.readableBytes();
            arrowBuffers.add(new ArrowBuffer(offset, size));
            offset += size;
        }
        this.buffersLayout = Collections.unmodifiableList(arrowBuffers);
    }

    @Override
    public byte getMessageType() {
        return 3;
    }

    public int getLength() {
        return this.length;
    }

    public List<ArrowFieldNode> getNodes() {
        return this.nodes;
    }

    public List<ArrowBuf> getBuffers() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        return this.buffers;
    }

    public ArrowRecordBatch cloneWithTransfer(BufferAllocator allocator) {
        List<ArrowBuf> newBufs = this.buffers.stream().map(buf -> buf.getReferenceManager().transferOwnership((ArrowBuf)buf, allocator).getTransferredBuffer().writerIndex(buf.writerIndex())).collect(Collectors.toList());
        this.close();
        return new ArrowRecordBatch(false, this.length, this.nodes, newBufs);
    }

    public List<ArrowBuffer> getBuffersLayout() {
        return this.buffersLayout;
    }

    @Override
    public int writeTo(FlatBufferBuilder builder) {
        RecordBatch.startNodesVector(builder, this.nodes.size());
        int nodesOffset = FBSerializables.writeAllStructsToVector(builder, this.nodes);
        RecordBatch.startBuffersVector(builder, this.buffers.size());
        int buffersOffset = FBSerializables.writeAllStructsToVector(builder, this.buffersLayout);
        RecordBatch.startRecordBatch(builder);
        RecordBatch.addLength(builder, this.length);
        RecordBatch.addNodes(builder, nodesOffset);
        RecordBatch.addBuffers(builder, buffersOffset);
        return RecordBatch.endRecordBatch(builder);
    }

    @Override
    public <T> T accepts(ArrowMessage.ArrowMessageVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (ArrowBuf arrowBuf : this.buffers) {
                arrowBuf.getReferenceManager().release();
            }
        }
    }

    public String toString() {
        return "ArrowRecordBatch [length=" + this.length + ", nodes=" + this.nodes + ", #buffers=" + this.buffers.size() + ", buffersLayout=" + this.buffersLayout + ", closed=" + this.closed + "]";
    }

    @Override
    public long computeBodyLength() {
        long size = 0L;
        List<ArrowBuf> buffers = this.getBuffers();
        List<ArrowBuffer> buffersLayout = this.getBuffersLayout();
        if (buffers.size() != buffersLayout.size()) {
            throw new IllegalStateException("the layout does not match: " + buffers.size() + " != " + buffersLayout.size());
        }
        for (int i = 0; i < buffers.size(); ++i) {
            ArrowBuf buffer = buffers.get(i);
            ArrowBuffer layout = buffersLayout.get(i);
            size = layout.getOffset() + buffer.readableBytes();
            size = DataSizeRoundingUtil.roundUpTo8Multiple(size);
        }
        return size;
    }
}

