/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc;

import cdjd.com.fasterxml.jackson.core.JsonEncoding;
import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import cdjd.com.fasterxml.jackson.databind.MappingJsonFactory;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseVariableWidthVector;
import cdjd.org.apache.arrow.vector.BigIntVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.BufferLayout;
import cdjd.org.apache.arrow.vector.DateDayVector;
import cdjd.org.apache.arrow.vector.DateMilliVector;
import cdjd.org.apache.arrow.vector.DecimalVector;
import cdjd.org.apache.arrow.vector.DurationVector;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.FixedSizeBinaryVector;
import cdjd.org.apache.arrow.vector.Float4Vector;
import cdjd.org.apache.arrow.vector.Float8Vector;
import cdjd.org.apache.arrow.vector.IntVector;
import cdjd.org.apache.arrow.vector.IntervalDayVector;
import cdjd.org.apache.arrow.vector.IntervalYearVector;
import cdjd.org.apache.arrow.vector.SmallIntVector;
import cdjd.org.apache.arrow.vector.TimeMicroVector;
import cdjd.org.apache.arrow.vector.TimeMilliVector;
import cdjd.org.apache.arrow.vector.TimeNanoVector;
import cdjd.org.apache.arrow.vector.TimeSecVector;
import cdjd.org.apache.arrow.vector.TimeStampMicroTZVector;
import cdjd.org.apache.arrow.vector.TimeStampMicroVector;
import cdjd.org.apache.arrow.vector.TimeStampMilliTZVector;
import cdjd.org.apache.arrow.vector.TimeStampMilliVector;
import cdjd.org.apache.arrow.vector.TimeStampNanoTZVector;
import cdjd.org.apache.arrow.vector.TimeStampNanoVector;
import cdjd.org.apache.arrow.vector.TimeStampSecTZVector;
import cdjd.org.apache.arrow.vector.TimeStampSecVector;
import cdjd.org.apache.arrow.vector.TinyIntVector;
import cdjd.org.apache.arrow.vector.TypeLayout;
import cdjd.org.apache.arrow.vector.UInt1Vector;
import cdjd.org.apache.arrow.vector.UInt2Vector;
import cdjd.org.apache.arrow.vector.UInt4Vector;
import cdjd.org.apache.arrow.vector.UInt8Vector;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.dictionary.Dictionary;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryProvider;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import cdjd.org.apache.arrow.vector.util.DecimalUtility;
import cdjd.org.apache.arrow.vector.util.DictionaryUtility;
import cdjd.org.apache.commons.codec.binary.Hex;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JsonFileWriter
implements AutoCloseable {
    private final JsonGenerator generator;
    private Schema schema;

    public static JSONWriteConfig config() {
        return new JSONWriteConfig();
    }

    public JsonFileWriter(File outputFile) throws IOException {
        this(outputFile, JsonFileWriter.config());
    }

    public JsonFileWriter(File outputFile, JSONWriteConfig config) throws IOException {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        this.generator = jsonFactory.createGenerator(outputFile, JsonEncoding.UTF8);
        if (config.pretty) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            prettyPrinter.indentArraysWith(DefaultPrettyPrinter.NopIndenter.instance);
            this.generator.setPrettyPrinter(prettyPrinter);
        }
        this.generator.configure(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS, false);
    }

    public void start(Schema schema, DictionaryProvider provider) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(schema.getFields().size());
        HashSet<Long> dictionaryIdsUsed = new HashSet<Long>();
        this.schema = schema;
        for (Field field : schema.getFields()) {
            fields.add(DictionaryUtility.toMessageFormat(field, provider, dictionaryIdsUsed));
        }
        Schema updatedSchema = new Schema(fields, schema.getCustomMetadata());
        this.generator.writeStartObject();
        this.generator.writeObjectField("schema", updatedSchema);
        if (!dictionaryIdsUsed.isEmpty()) {
            this.writeDictionaryBatches(this.generator, dictionaryIdsUsed, provider);
        }
        this.generator.writeArrayFieldStart("batches");
    }

    private void writeDictionaryBatches(JsonGenerator generator, Set<Long> dictionaryIdsUsed, DictionaryProvider provider) throws IOException {
        generator.writeArrayFieldStart("dictionaries");
        for (Long id : dictionaryIdsUsed) {
            generator.writeStartObject();
            generator.writeObjectField("id", id);
            generator.writeFieldName("data");
            Dictionary dictionary = provider.lookup(id);
            FieldVector vector = dictionary.getVector();
            List<Field> fields = Collections.singletonList(vector.getField());
            List<FieldVector> vectors = Collections.singletonList(vector);
            VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector.getValueCount());
            this.writeBatch(root);
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    public void write(VectorSchemaRoot recordBatch) throws IOException {
        if (!recordBatch.getSchema().equals(this.schema)) {
            throw new IllegalArgumentException("record batches must have the same schema: " + this.schema);
        }
        this.writeBatch(recordBatch);
    }

    private void writeBatch(VectorSchemaRoot recordBatch) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeObjectField("count", recordBatch.getRowCount());
        this.generator.writeArrayFieldStart("columns");
        for (Field field : recordBatch.getSchema().getFields()) {
            FieldVector vector = recordBatch.getVector(field);
            this.writeFromVectorIntoJson(field, vector);
        }
        this.generator.writeEndArray();
        this.generator.writeEndObject();
    }

    private void writeFromVectorIntoJson(Field field, FieldVector vector) throws IOException {
        List<BufferLayout.BufferType> vectorTypes = TypeLayout.getTypeLayout(field.getType()).getBufferTypes();
        List<ArrowBuf> vectorBuffers = vector.getFieldBuffers();
        if (vectorTypes.size() != vectorBuffers.size()) {
            throw new IllegalArgumentException("vector types and inner vector buffers are not the same size: " + vectorTypes.size() + " != " + vectorBuffers.size());
        }
        this.generator.writeStartObject();
        this.generator.writeObjectField("name", field.getName());
        int valueCount = vector.getValueCount();
        this.generator.writeObjectField("count", valueCount);
        for (int v = 0; v < vectorTypes.size(); ++v) {
            BufferLayout.BufferType bufferType = vectorTypes.get(v);
            ArrowBuf vectorBuffer = vectorBuffers.get(v);
            this.generator.writeArrayFieldStart(bufferType.getName());
            int bufferValueCount = bufferType.equals((Object)BufferLayout.BufferType.OFFSET) ? valueCount + 1 : valueCount;
            for (int i = 0; i < bufferValueCount; ++i) {
                if (bufferType.equals((Object)BufferLayout.BufferType.DATA) && (vector.getMinorType() == Types.MinorType.VARCHAR || vector.getMinorType() == Types.MinorType.VARBINARY)) {
                    this.writeValueToGenerator(bufferType, vectorBuffer, vectorBuffers.get(v - 1), vector, i);
                    continue;
                }
                this.writeValueToGenerator(bufferType, vectorBuffer, null, vector, i);
            }
            this.generator.writeEndArray();
        }
        List<Field> fields = field.getChildren();
        List<FieldVector> children = vector.getChildrenFromFields();
        if (fields.size() != children.size()) {
            throw new IllegalArgumentException("fields and children are not the same size: " + fields.size() + " != " + children.size());
        }
        if (fields.size() > 0) {
            this.generator.writeArrayFieldStart("children");
            for (int i = 0; i < fields.size(); ++i) {
                Field childField = fields.get(i);
                FieldVector childVector = children.get(i);
                this.writeFromVectorIntoJson(childField, childVector);
            }
            this.generator.writeEndArray();
        }
        this.generator.writeEndObject();
    }

    private void writeValueToGenerator(BufferLayout.BufferType bufferType, ArrowBuf buffer, ArrowBuf offsetBuffer, FieldVector vector, int index) throws IOException {
        if (bufferType.equals((Object)BufferLayout.BufferType.TYPE)) {
            this.generator.writeNumber(buffer.getByte(index * 1));
        } else if (bufferType.equals((Object)BufferLayout.BufferType.OFFSET)) {
            this.generator.writeNumber(buffer.getInt(index * 4));
        } else if (bufferType.equals((Object)BufferLayout.BufferType.VALIDITY)) {
            this.generator.writeNumber(vector.isNull(index) ? 0 : 1);
        } else if (bufferType.equals((Object)BufferLayout.BufferType.DATA)) {
            switch (vector.getMinorType()) {
                case TINYINT: {
                    this.generator.writeNumber(TinyIntVector.get(buffer, index));
                    break;
                }
                case SMALLINT: {
                    this.generator.writeNumber(SmallIntVector.get(buffer, index));
                    break;
                }
                case INT: {
                    this.generator.writeNumber(IntVector.get(buffer, index));
                    break;
                }
                case BIGINT: {
                    this.generator.writeString(String.valueOf(BigIntVector.get(buffer, index)));
                    break;
                }
                case UINT1: {
                    this.generator.writeNumber(UInt1Vector.getNoOverflow(buffer, index));
                    break;
                }
                case UINT2: {
                    this.generator.writeNumber(UInt2Vector.get(buffer, index));
                    break;
                }
                case UINT4: {
                    this.generator.writeNumber(UInt4Vector.getNoOverflow(buffer, index));
                    break;
                }
                case UINT8: {
                    this.generator.writeString(UInt8Vector.getNoOverflow(buffer, index).toString());
                    break;
                }
                case FLOAT4: {
                    this.generator.writeNumber(Float4Vector.get(buffer, index));
                    break;
                }
                case FLOAT8: {
                    this.generator.writeNumber(Float8Vector.get(buffer, index));
                    break;
                }
                case DATEDAY: {
                    this.generator.writeNumber(DateDayVector.get(buffer, index));
                    break;
                }
                case DATEMILLI: {
                    this.generator.writeNumber(DateMilliVector.get(buffer, index));
                    break;
                }
                case TIMESEC: {
                    this.generator.writeNumber(TimeSecVector.get(buffer, index));
                    break;
                }
                case TIMEMILLI: {
                    this.generator.writeNumber(TimeMilliVector.get(buffer, index));
                    break;
                }
                case TIMEMICRO: {
                    this.generator.writeNumber(TimeMicroVector.get(buffer, index));
                    break;
                }
                case TIMENANO: {
                    this.generator.writeNumber(TimeNanoVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPSEC: {
                    this.generator.writeNumber(TimeStampSecVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPMILLI: {
                    this.generator.writeNumber(TimeStampMilliVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPMICRO: {
                    this.generator.writeNumber(TimeStampMicroVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPNANO: {
                    this.generator.writeNumber(TimeStampNanoVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPSECTZ: {
                    this.generator.writeNumber(TimeStampSecTZVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPMILLITZ: {
                    this.generator.writeNumber(TimeStampMilliTZVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPMICROTZ: {
                    this.generator.writeNumber(TimeStampMicroTZVector.get(buffer, index));
                    break;
                }
                case TIMESTAMPNANOTZ: {
                    this.generator.writeNumber(TimeStampNanoTZVector.get(buffer, index));
                    break;
                }
                case DURATION: {
                    this.generator.writeNumber(DurationVector.get(buffer, index));
                    break;
                }
                case INTERVALYEAR: {
                    this.generator.writeNumber(IntervalYearVector.getTotalMonths(buffer, index));
                    break;
                }
                case INTERVALDAY: {
                    this.generator.writeStartObject();
                    this.generator.writeObjectField("days", IntervalDayVector.getDays(buffer, index));
                    this.generator.writeObjectField("milliseconds", IntervalDayVector.getMilliseconds(buffer, index));
                    this.generator.writeEndObject();
                    break;
                }
                case BIT: {
                    this.generator.writeNumber(BitVectorHelper.get(buffer, index));
                    break;
                }
                case VARBINARY: {
                    Preconditions.checkNotNull(offsetBuffer);
                    String hexString = Hex.encodeHexString(BaseVariableWidthVector.get(buffer, offsetBuffer, index));
                    this.generator.writeObject(hexString);
                    break;
                }
                case FIXEDSIZEBINARY: {
                    int byteWidth = ((FixedSizeBinaryVector)vector).getByteWidth();
                    String fixedSizeHexString = Hex.encodeHexString(FixedSizeBinaryVector.get(buffer, index, byteWidth));
                    this.generator.writeObject(fixedSizeHexString);
                    break;
                }
                case VARCHAR: {
                    Preconditions.checkNotNull(offsetBuffer);
                    byte[] b = BaseVariableWidthVector.get(buffer, offsetBuffer, index);
                    this.generator.writeString(new String(b, "UTF-8"));
                    break;
                }
                case DECIMAL: {
                    int scale = ((DecimalVector)vector).getScale();
                    BigDecimal decimalValue = DecimalUtility.getBigDecimalFromArrowBuf(buffer, index, scale);
                    this.generator.writeString(decimalValue.unscaledValue().toString());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("minor type: " + (Object)((Object)vector.getMinorType()));
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.generator.writeEndArray();
        this.generator.writeEndObject();
        this.generator.close();
    }

    public static final class JSONWriteConfig {
        private final boolean pretty;

        private JSONWriteConfig(boolean pretty) {
            this.pretty = pretty;
        }

        private JSONWriteConfig() {
            this.pretty = false;
        }

        public JSONWriteConfig pretty(boolean pretty) {
            return new JSONWriteConfig(pretty);
        }
    }
}

