/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc;

import cdjd.com.fasterxml.jackson.core.JsonParseException;
import cdjd.com.fasterxml.jackson.core.JsonParser;
import cdjd.com.fasterxml.jackson.core.JsonToken;
import cdjd.com.fasterxml.jackson.databind.MappingJsonFactory;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.BufferLayout;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.TypeLayout;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.dictionary.Dictionary;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryProvider;
import cdjd.org.apache.arrow.vector.ipc.InvalidArrowFileException;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import cdjd.org.apache.arrow.vector.util.DecimalUtility;
import cdjd.org.apache.arrow.vector.util.DictionaryUtility;
import cdjd.org.apache.commons.codec.DecoderException;
import cdjd.org.apache.commons.codec.binary.Hex;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonFileReader
implements AutoCloseable,
DictionaryProvider {
    private final JsonParser parser;
    private final BufferAllocator allocator;
    private Schema schema;
    private Map<Long, Dictionary> dictionaries;
    private Boolean started = false;

    public JsonFileReader(File inputFile, BufferAllocator allocator) throws JsonParseException, IOException {
        this.allocator = allocator;
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        this.parser = jsonFactory.createParser(inputFile);
        this.parser.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    @Override
    public Dictionary lookup(long id) {
        if (!this.started.booleanValue()) {
            throw new IllegalStateException("Unable to lookup until after read() has started");
        }
        return this.dictionaries.get(id);
    }

    public Schema start() throws JsonParseException, IOException {
        this.readToken(JsonToken.START_OBJECT);
        Schema originalSchema = this.readNextField("schema", Schema.class);
        ArrayList<Field> fields = new ArrayList<Field>();
        this.dictionaries = new HashMap<Long, Dictionary>();
        for (Field field : originalSchema.getFields()) {
            fields.add(DictionaryUtility.toMemoryFormat(field, this.allocator, this.dictionaries));
        }
        this.schema = new Schema(fields, originalSchema.getCustomMetadata());
        if (!this.dictionaries.isEmpty()) {
            this.nextFieldIs("dictionaries");
            this.readDictionaryBatches();
        }
        this.nextFieldIs("batches");
        this.readToken(JsonToken.START_ARRAY);
        this.started = true;
        return this.schema;
    }

    private void readDictionaryBatches() throws JsonParseException, IOException {
        boolean haveDictionaryBatch;
        this.readToken(JsonToken.START_ARRAY);
        JsonToken token = this.parser.nextToken();
        boolean bl = haveDictionaryBatch = token == JsonToken.START_OBJECT;
        while (haveDictionaryBatch) {
            long id = this.readNextField("id", Long.class);
            Dictionary dict = this.dictionaries.get(id);
            if (dict == null) {
                throw new IllegalArgumentException("Dictionary with id: " + id + " missing encoding from schema Field");
            }
            this.nextFieldIs("data");
            FieldVector vector = dict.getVector();
            List<Field> fields = Collections.singletonList(vector.getField());
            List<FieldVector> vectors = Collections.singletonList(vector);
            VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector.getValueCount());
            this.read(root);
            this.readToken(JsonToken.END_OBJECT);
            token = this.parser.nextToken();
            haveDictionaryBatch = token == JsonToken.START_OBJECT;
        }
        if (token != JsonToken.END_ARRAY) {
            throw new IllegalArgumentException("Invalid token: " + (Object)((Object)token) + " expected end of array at " + this.parser.getTokenLocation());
        }
    }

    public boolean read(VectorSchemaRoot root) throws IOException {
        JsonToken t = this.parser.nextToken();
        if (t == JsonToken.START_OBJECT) {
            int count = this.readNextField("count", Integer.class);
            root.setRowCount(count);
            this.nextFieldIs("columns");
            this.readToken(JsonToken.START_ARRAY);
            for (Field field : root.getSchema().getFields()) {
                FieldVector vector = root.getVector(field);
                this.readFromJsonIntoVector(field, vector);
            }
            this.readToken(JsonToken.END_ARRAY);
            this.readToken(JsonToken.END_OBJECT);
            return true;
        }
        if (t == JsonToken.END_ARRAY) {
            root.setRowCount(0);
            return false;
        }
        throw new IllegalArgumentException("Invalid token: " + (Object)((Object)t));
    }

    public VectorSchemaRoot read() throws IOException {
        JsonToken t = this.parser.nextToken();
        if (t == JsonToken.START_OBJECT) {
            VectorSchemaRoot recordBatch = VectorSchemaRoot.create(this.schema, this.allocator);
            int count = this.readNextField("count", Integer.class);
            recordBatch.setRowCount(count);
            this.nextFieldIs("columns");
            this.readToken(JsonToken.START_ARRAY);
            for (Field field : this.schema.getFields()) {
                FieldVector vector = recordBatch.getVector(field);
                this.readFromJsonIntoVector(field, vector);
            }
            this.readToken(JsonToken.END_ARRAY);
            this.readToken(JsonToken.END_OBJECT);
            return recordBatch;
        }
        if (t == JsonToken.END_ARRAY) {
            return null;
        }
        throw new IllegalArgumentException("Invalid token: " + (Object)((Object)t));
    }

    private ArrowBuf readIntoBuffer(BufferAllocator allocator, BufferLayout.BufferType bufferType, Types.MinorType type, int count) throws IOException {
        BufferReader reader;
        block28: {
            block31: {
                BufferHelper helper;
                block30: {
                    block29: {
                        block27: {
                            helper = new BufferHelper();
                            reader = null;
                            if (!bufferType.equals((Object)BufferLayout.BufferType.VALIDITY)) break block27;
                            reader = helper.BIT;
                            break block28;
                        }
                        if (!bufferType.equals((Object)BufferLayout.BufferType.OFFSET)) break block29;
                        reader = type == Types.MinorType.LARGEVARCHAR || type == Types.MinorType.LARGEVARBINARY ? helper.INT8 : helper.INT4;
                        break block28;
                    }
                    if (!bufferType.equals((Object)BufferLayout.BufferType.TYPE)) break block30;
                    reader = helper.INT1;
                    break block28;
                }
                if (!bufferType.equals((Object)BufferLayout.BufferType.DATA)) break block31;
                switch (type) {
                    case BIT: {
                        reader = helper.BIT;
                        break block28;
                    }
                    case TINYINT: {
                        reader = helper.INT1;
                        break block28;
                    }
                    case SMALLINT: {
                        reader = helper.INT2;
                        break block28;
                    }
                    case INT: {
                        reader = helper.INT4;
                        break block28;
                    }
                    case BIGINT: {
                        reader = helper.INT8;
                        break block28;
                    }
                    case UINT1: {
                        reader = helper.UINT1;
                        break block28;
                    }
                    case UINT2: {
                        reader = helper.UINT2;
                        break block28;
                    }
                    case UINT4: {
                        reader = helper.UINT4;
                        break block28;
                    }
                    case UINT8: {
                        reader = helper.UINT8;
                        break block28;
                    }
                    case FLOAT4: {
                        reader = helper.FLOAT4;
                        break block28;
                    }
                    case FLOAT8: {
                        reader = helper.FLOAT8;
                        break block28;
                    }
                    case DECIMAL: {
                        reader = helper.DECIMAL;
                        break block28;
                    }
                    case FIXEDSIZEBINARY: {
                        reader = helper.FIXEDSIZEBINARY;
                        break block28;
                    }
                    case VARCHAR: {
                        reader = helper.VARCHAR;
                        break block28;
                    }
                    case LARGEVARCHAR: {
                        reader = helper.LARGEVARCHAR;
                        break block28;
                    }
                    case VARBINARY: {
                        reader = helper.VARBINARY;
                        break block28;
                    }
                    case LARGEVARBINARY: {
                        reader = helper.LARGEVARBINARY;
                        break block28;
                    }
                    case DATEDAY: {
                        reader = helper.INT4;
                        break block28;
                    }
                    case DATEMILLI: {
                        reader = helper.INT8;
                        break block28;
                    }
                    case TIMESEC: 
                    case TIMEMILLI: {
                        reader = helper.INT4;
                        break block28;
                    }
                    case TIMEMICRO: 
                    case TIMENANO: {
                        reader = helper.INT8;
                        break block28;
                    }
                    case TIMESTAMPNANO: 
                    case TIMESTAMPMICRO: 
                    case TIMESTAMPMILLI: 
                    case TIMESTAMPSEC: 
                    case TIMESTAMPNANOTZ: 
                    case TIMESTAMPMICROTZ: 
                    case TIMESTAMPMILLITZ: 
                    case TIMESTAMPSECTZ: {
                        reader = helper.INT8;
                        break block28;
                    }
                    case INTERVALYEAR: {
                        reader = helper.INT4;
                        break block28;
                    }
                    case INTERVALDAY: {
                        reader = helper.DAY_MILLIS;
                        break block28;
                    }
                    case DURATION: {
                        reader = helper.INT8;
                        break block28;
                    }
                    default: {
                        throw new UnsupportedOperationException("Cannot read array of type " + (Object)((Object)type));
                    }
                }
            }
            throw new InvalidArrowFileException("Unrecognized buffer type " + (Object)((Object)bufferType));
        }
        ArrowBuf buf = reader.readBuffer(allocator, count);
        Preconditions.checkNotNull(buf);
        return buf;
    }

    private void readFromJsonIntoVector(Field field, FieldVector vector) throws JsonParseException, IOException {
        TypeLayout typeLayout = TypeLayout.getTypeLayout(field.getType());
        List<BufferLayout.BufferType> vectorTypes = typeLayout.getBufferTypes();
        ArrowBuf[] vectorBuffers = new ArrowBuf[vectorTypes.size()];
        this.readToken(JsonToken.START_OBJECT);
        String name = this.readNextField("name", String.class);
        if (this.started.booleanValue() && !Objects.equals(field.getName(), name)) {
            throw new IllegalArgumentException("Expected field " + field.getName() + " but got " + name);
        }
        int valueCount = this.readNextField("count", Integer.class);
        vector.setInitialCapacity(valueCount);
        for (int v = 0; v < vectorTypes.size(); ++v) {
            BufferLayout.BufferType bufferType = vectorTypes.get(v);
            this.nextFieldIs(bufferType.getName());
            int innerBufferValueCount = valueCount;
            if (bufferType.equals((Object)BufferLayout.BufferType.OFFSET)) {
                innerBufferValueCount = valueCount + 1;
            }
            vectorBuffers[v] = this.readIntoBuffer(this.allocator, bufferType, vector.getMinorType(), innerBufferValueCount);
        }
        if (vectorBuffers.length == 0) {
            this.readToken(JsonToken.END_OBJECT);
            return;
        }
        int nullCount = BitVectorHelper.getNullCount(vectorBuffers[0], valueCount);
        ArrowFieldNode fieldNode = new ArrowFieldNode(valueCount, nullCount);
        vector.loadFieldBuffers(fieldNode, Arrays.asList(vectorBuffers));
        List<Field> fields = field.getChildren();
        if (!fields.isEmpty()) {
            List<FieldVector> vectorChildren = vector.getChildrenFromFields();
            if (fields.size() != vectorChildren.size()) {
                throw new IllegalArgumentException("fields and children are not the same size: " + fields.size() + " != " + vectorChildren.size());
            }
            this.nextFieldIs("children");
            this.readToken(JsonToken.START_ARRAY);
            for (int i = 0; i < fields.size(); ++i) {
                Field childField = fields.get(i);
                FieldVector childVector = vectorChildren.get(i);
                this.readFromJsonIntoVector(childField, childVector);
            }
            this.readToken(JsonToken.END_ARRAY);
        }
        this.readToken(JsonToken.END_OBJECT);
        for (ArrowBuf buffer : vectorBuffers) {
            buffer.getReferenceManager().release();
        }
    }

    private byte[] decodeHexSafe(String hexString) throws IOException {
        try {
            return Hex.decodeHex(hexString.toCharArray());
        }
        catch (DecoderException e) {
            throw new IOException("Unable to decode hex string: " + hexString, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        for (Dictionary dictionary : this.dictionaries.values()) {
            dictionary.getVector().close();
        }
    }

    private <T> T readNextField(String expectedFieldName, Class<T> c) throws IOException, JsonParseException {
        this.nextFieldIs(expectedFieldName);
        this.parser.nextToken();
        return this.parser.readValueAs(c);
    }

    private void nextFieldIs(String expectedFieldName) throws IOException, JsonParseException {
        String name = this.parser.nextFieldName();
        if (name == null || !name.equals(expectedFieldName)) {
            throw new IllegalStateException("Expected " + expectedFieldName + " but got " + name);
        }
    }

    private void readToken(JsonToken expected) throws JsonParseException, IOException {
        JsonToken t = this.parser.nextToken();
        if (t != expected) {
            throw new IllegalStateException("Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)t));
        }
    }

    private class BufferHelper {
        BufferReader BIT = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int bufferSize = BitVectorHelper.getValidityBufferSize(count);
                ArrowBuf buf = allocator.buffer(bufferSize);
                buf.setZero(0L, bufferSize);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BitVectorHelper.setValidityBit(buf, i, JsonFileReader.this.parser.readValueAs(Boolean.class) != false ? 1 : 0);
                }
                buf.writerIndex(bufferSize);
                return buf;
            }
        };
        BufferReader DAY_MILLIS = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 8;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.readToken(JsonToken.START_OBJECT);
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("days", Integer.class));
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("milliseconds", Integer.class));
                    JsonFileReader.this.readToken(JsonToken.END_OBJECT);
                }
                return buf;
            }
        };
        BufferReader INT1 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 1;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeByte(JsonFileReader.this.parser.getByteValue());
                }
                return buf;
            }
        };
        BufferReader INT2 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 2;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeShort(JsonFileReader.this.parser.getShortValue());
                }
                return buf;
            }
        };
        BufferReader INT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 4;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeInt(JsonFileReader.this.parser.getIntValue());
                }
                return buf;
            }
        };
        BufferReader INT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 8;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    String value = JsonFileReader.this.parser.getValueAsString();
                    buf.writeLong(Long.valueOf(value));
                }
                return buf;
            }
        };
        BufferReader UINT1 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 1;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeByte(JsonFileReader.this.parser.getShortValue() & 0xFF);
                }
                return buf;
            }
        };
        BufferReader UINT2 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 2;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeShort(JsonFileReader.this.parser.getIntValue() & 0xFFFF);
                }
                return buf;
            }
        };
        BufferReader UINT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 4;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeInt((int)JsonFileReader.this.parser.getLongValue());
                }
                return buf;
            }
        };
        BufferReader UINT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 8;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BigInteger value = new BigInteger(JsonFileReader.this.parser.getValueAsString());
                    buf.writeLong(value.longValue());
                }
                return buf;
            }
        };
        BufferReader FLOAT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 4;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeFloat(JsonFileReader.this.parser.getFloatValue());
                }
                return buf;
            }
        };
        BufferReader FLOAT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 8;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeDouble(JsonFileReader.this.parser.getDoubleValue());
                }
                return buf;
            }
        };
        BufferReader DECIMAL = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int size = count * 16;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BigDecimal decimalValue = new BigDecimal(JsonFileReader.this.parser.readValueAs(String.class));
                    DecimalUtility.writeBigDecimalToArrowBuf(decimalValue, buf, i);
                }
                buf.writerIndex(size);
                return buf;
            }
        };
        BufferReader FIXEDSIZEBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    byte[] value = JsonFileReader.this.decodeHexSafe(JsonFileReader.this.parser.readValueAs(String.class));
                    values.add(value);
                }
                int byteWidth = count > 0 ? ((byte[])values.get(0)).length : 0;
                ArrowBuf buf = allocator.buffer(byteWidth * count);
                for (byte[] value : values) {
                    buf.writeBytes(value);
                }
                return buf;
            }
        };
        BufferReader VARCHAR = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                int bufferSize = 0;
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    byte[] value = JsonFileReader.this.parser.getValueAsString().getBytes(StandardCharsets.UTF_8);
                    values.add(value);
                    bufferSize += value.length;
                }
                ArrowBuf buf = allocator.buffer(bufferSize);
                for (byte[] value : values) {
                    buf.writeBytes(value);
                }
                return buf;
            }
        };
        BufferReader LARGEVARCHAR = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                long bufferSize = 0L;
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    byte[] value = JsonFileReader.this.parser.getValueAsString().getBytes(StandardCharsets.UTF_8);
                    values.add(value);
                    bufferSize += (long)value.length;
                }
                ArrowBuf buf = allocator.buffer(bufferSize);
                for (byte[] value : values) {
                    buf.writeBytes(value);
                }
                return buf;
            }
        };
        BufferReader VARBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                int bufferSize = 0;
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    byte[] value = JsonFileReader.this.decodeHexSafe(JsonFileReader.this.parser.readValueAs(String.class));
                    values.add(value);
                    bufferSize += value.length;
                }
                ArrowBuf buf = allocator.buffer(bufferSize);
                for (byte[] value : values) {
                    buf.writeBytes(value);
                }
                return buf;
            }
        };
        BufferReader LARGEVARBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                long bufferSize = 0L;
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    byte[] value = JsonFileReader.this.decodeHexSafe(JsonFileReader.this.parser.readValueAs(String.class));
                    values.add(value);
                    bufferSize += (long)value.length;
                }
                ArrowBuf buf = allocator.buffer(bufferSize);
                for (byte[] value : values) {
                    buf.writeBytes(value);
                }
                return buf;
            }
        };

        private BufferHelper() {
        }
    }

    private abstract class BufferReader {
        private BufferReader() {
        }

        protected abstract ArrowBuf read(BufferAllocator var1, int var2) throws IOException;

        ArrowBuf readBuffer(BufferAllocator allocator, int count) throws IOException {
            JsonFileReader.this.readToken(JsonToken.START_ARRAY);
            ArrowBuf buf = this.read(allocator, count);
            JsonFileReader.this.readToken(JsonToken.END_ARRAY);
            return buf;
        }
    }
}

