/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ipc.ArrowReader;
import cdjd.org.apache.arrow.vector.ipc.ReadChannel;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import cdjd.org.apache.arrow.vector.ipc.message.MessageChannelReader;
import cdjd.org.apache.arrow.vector.ipc.message.MessageResult;
import cdjd.org.apache.arrow.vector.ipc.message.MessageSerializer;
import cdjd.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class ArrowStreamReader
extends ArrowReader {
    private MessageChannelReader messageReader;
    private int loadedDictionaryCount;

    public ArrowStreamReader(MessageChannelReader messageReader, BufferAllocator allocator) {
        super(allocator);
        this.messageReader = messageReader;
    }

    public ArrowStreamReader(ReadableByteChannel in, BufferAllocator allocator) {
        this(new MessageChannelReader(new ReadChannel(in), allocator), allocator);
    }

    public ArrowStreamReader(InputStream in, BufferAllocator allocator) {
        this(Channels.newChannel(in), allocator);
    }

    @Override
    public long bytesRead() {
        return this.messageReader.bytesRead();
    }

    @Override
    protected void closeReadSource() throws IOException {
        this.messageReader.close();
    }

    @Override
    public boolean loadNextBatch() throws IOException {
        this.prepareLoadNextBatch();
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            return false;
        }
        if (result.getMessage().headerType() == 3) {
            ArrowBuf bodyBuffer = result.getBodyBuffer();
            if (bodyBuffer == null) {
                bodyBuffer = this.allocator.getEmpty();
            }
            ArrowRecordBatch batch = MessageSerializer.deserializeRecordBatch(result.getMessage(), bodyBuffer);
            this.loadRecordBatch(batch);
            this.checkDictionaries();
            return true;
        }
        if (result.getMessage().headerType() == 2) {
            ArrowDictionaryBatch dictionaryBatch = this.readDictionary(result);
            this.loadDictionary(dictionaryBatch);
            ++this.loadedDictionaryCount;
            return this.loadNextBatch();
        }
        throw new IOException("Expected RecordBatch or DictionaryBatch but header was " + result.getMessage().headerType());
    }

    private void checkDictionaries() throws IOException {
        if (this.loadedDictionaryCount == this.dictionaries.size()) {
            return;
        }
        for (FieldVector vector : this.getVectorSchemaRoot().getFieldVectors()) {
            DictionaryEncoding encoding = vector.getField().getDictionary();
            if (encoding == null || this.dictionaries.containsKey(encoding.getId()) || vector.getNullCount() >= vector.getValueCount()) continue;
            throw new IOException("The dictionary was not available, id was:" + encoding.getId());
        }
    }

    @Override
    protected Schema readSchema() throws IOException {
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        if (result.getMessage().headerType() != 1) {
            throw new IOException("Expected schema but header was " + result.getMessage().headerType());
        }
        return MessageSerializer.deserializeSchema(result.getMessage());
    }

    private ArrowDictionaryBatch readDictionary(MessageResult result) throws IOException {
        ArrowBuf bodyBuffer = result.getBodyBuffer();
        if (bodyBuffer == null) {
            bodyBuffer = this.allocator.getEmpty();
        }
        return MessageSerializer.deserializeDictionaryBatch(result.getMessage(), bodyBuffer);
    }
}

